<?php

if ( ! function_exists( 'lab23_add_robots_tag_wp_head' ) ) {
    function lab23_add_robots_tag_wp_head()
    {
        $robots_content = null;

        if ( is_singular() ) {

            $post_type = get_post_type();

            if ( $post_type === 'post' || $post_type === 'page' ) {
                $post_id = get_the_ID();
                $noindex = get_post_meta( $post_id, 'lab23_noindex', true );
                $nofollow = get_post_meta( $post_id, 'lab23_nofollow', true );

                if ($noindex && $nofollow) {
                    $robots_content = 'noindex,nofollow';
                } elseif ($noindex) {
                    $robots_content = 'noindex';
                } elseif ($nofollow) {
                    $robots_content = 'nofollow';
                }
            }
        }
        if ($robots_content) :
?>
<meta name="robots" content="<?php echo $robots_content; ?>">
        <?php
        endif;
    }
    add_action( 'wp_head', 'lab23_add_robots_tag_wp_head', 10 );
}

if ( ! function_exists( 'lab23_add_meta_description_wp_head' ) ) {
    function lab23_add_meta_description_wp_head() {
        $meta_description = '';

        if (is_singular() ) {

            $post_type = get_post_type();

            if ($post_type === 'post' || $post_type === 'page' ) {
                $post_id = get_the_ID();
                $meta_description = get_post_meta($post_id, 'lab23_seo_description', true);
            }
        }

        if ( is_home() ) {
            $meta_description = get_option( 'lab23_meta_description', '' );
        } else {
            if (is_archive() ) {
                $meta_description = get_option( 'lab23_meta_description', '' );
            }
        }

        if ( empty( $meta_description ) ) $meta_description = LAB23_BLOG_DESCRIPTION;

        $meta_description = wp_strip_all_tags( $meta_description, true );
        $meta_description = esc_attr( $meta_description );

        if ( ! empty( $meta_description ) ) :
        ?>
<meta name="description" content="<?php echo $meta_description; ?>">
<?php
        endif;
    }
    add_action( 'wp_head', 'lab23_add_meta_description_wp_head', 10);
}

if ( ! function_exists( 'lab23_get_ogp_image' ) ) {
    function lab23_get_ogp_image()
    {
        $image = '';

        if (is_singular() ) {
            $post_id = get_the_ID();
            $thumb = get_the_post_thumbnail_url($post_id, 'full' );

            if ($thumb) $image = $thumb;
        }

        if (!$image) {
            $default = esc_url(get_option( 'lab23_home_ogp_image', '' ) );

            if ($default) $image = $default;
        }

        return $image;
    }
}

if ( ! function_exists( 'lab23_get_ogp_title' ) ) {
    function lab23_get_ogp_title() {
        $title = '';

        if ( is_singular() ) {

            $post_id	= get_the_ID();
            $seo_title  = get_post_meta( $post_id, 'lab23_seo_title', true );

            if ( ! empty( $seo_title ) ) {
                $title = $seo_title;
            } else {

                if ( is_front_page() ) {
                    $title = LAB23_BLOG_NAME;
                } else {
                    $title = get_the_title();
                }
                
            }
            
        } elseif ( is_archive() ) {
            $title = get_the_archive_title();
        } else {
            $title = LAB23_BLOG_NAME;
        }

        $title = wp_strip_all_tags( $title, true );

        return esc_attr( $title );
    }
}

if ( ! function_exists( 'lab23_get_ogp_description' ) ) {
    function lab23_get_ogp_description()
    {
        $description = '';

        if (is_singular() ) {
            $post_id = get_the_ID();
            $post_desc = get_post_meta($post_id, 'lab23_seo_description', true);

            if ($post_desc) {

                $description = esc_attr($post_desc);
            } else if (has_excerpt($post_id) ) {

                $description = lab23_get_the_excerpt_outside($post_id);
            } else {

                $description = lab23_get_excerpt(140, $post_id);
            }
        } elseif (is_archive() ) {

            if (is_category() ) {
                $description = category_description();
            }

            if (is_tag() ) {
                $description = tag_description();
            }
        }

        if ( ! $description ) {
            $default = get_option( 'lab23_meta_description', '' ) ? get_option( 'lab23_meta_description', '' ) : LAB23_BLOG_DESCRIPTION;
            $description = $default;
        }

        $description = wp_strip_all_tags($description, true);
        return esc_attr($description);
    }
}

if ( ! function_exists( 'lab23_add_ogp_wp_head' ) ) {
    function lab23_add_ogp_wp_head() {
        $title = lab23_get_ogp_title();
        $description = lab23_get_ogp_description();
        $http = ( is_ssl() ? 'https' : 'http' ) . '://';
        $url = $http . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];
        $image = lab23_get_ogp_image();

        // Twitter
        $size = get_option( 'lab23_twitter_ogp_size', 'summary_large_image' );
        ?>
<meta property="og:title" content="<?php echo $title; ?>">
<meta property="og:description" content="<?php echo $description; ?>">
<meta property="og:url" content="<?php echo $url; ?>">
<?php if($image) : ?>
<meta property="og:image" content="<?php echo $image; ?>">
<?php endif; ?>
<meta property="og:site_name" content="<?php echo LAB23_BLOG_NAME; ?>">
<meta property="og:locale" content="ja_JP">
<meta name="twitter:card" content="<?php echo $size; ?>">
<meta name="twitter:description" content="<?php echo $description; ?>">
<meta name="twitter:title" content="<?php echo $title; ?>">
<meta name="twitter:url" content="<?php echo $url; ?>">
<?php if($image) : ?>
<meta name="twitter:image" content="<?php echo $image; ?>">
<?php endif; ?>
<?php

    }
    add_action( 'wp_head', 'lab23_add_ogp_wp_head', 10 );
}

if ( ! function_exists( 'lab23_insert_adsense_wp_head' ) ) {
	function lab23_insert_adsense_wp_head() {

		$adsense_auto = get_option( 'lab23_adsense_auto', '' );

		if ( empty( $adsense_auto ) || is_404() ) return; 

		if( is_singular() ) {
			$post_id = get_the_ID();
			$hide_ad_value = get_post_meta( $post_id, 'no_ad', true );

			$adsense_code = $hide_ad_value !== 'is-off' ? $adsense_auto : '';
		} else {
			$adsense_code = $adsense_auto;
		}

		echo $adsense_code;

	}
    add_action( 'wp_head', 'lab23_insert_adsense_wp_head', 10 );
}
