<?php

$twitter_ogp_size = get_option('lab23_twitter_ogp_size', 'summary_large_image');

?>

<div class="lab23-settings-group-item current" id="seo">
	<div class="lab23-settings-group-item__inner">
		<div class="lab23-input-group">
			<label class="lab23-input-label" for="lab23_meta_description">Description</label>
			<div class="lab23-input">
				<textarea name="lab23_meta_description" id="lab23_meta_description"><?php echo get_option('lab23_meta_description', ''); ?></textarea>
			</div>

			<p class="lab23-input-desc">トップページのmeta descriptionやOGPに使用されます。（トップページを固定ページにしている場合は、その固定ページのmeta descriptionが出力されます。）</p>
		</div>
		<div class="lab23-input-group">
			<label class="lab23-input-label" for="lab23_analytics">Google Analytics</label>
			<div class="lab23-input">
				<input type="text" name="lab23_analytics" id="lab23_analytics" placeholder="G-XXXXXXXX" value="<?php echo get_option('lab23_analytics', ''); ?>">
			</div>
			<p class="lab23-input-desc">「G-」から始まるアナリティクスの測定IDを入れてください。</p>
			<p class="lab23-input-desc">タグマネージャーを使う場合は「タグ設定」に直接コードを入力してください。</p>
			<label class="lab23-input-label-wrap" for="lab23_nocount_login_user">
				<input type="checkbox" name="lab23_nocount_login_user" id="lab23_nocount_login_user" <?php if (get_option('lab23_nocount_login_user', '')) echo 'checked'; ?> />ログインしている場合はアナリティクスを計測しない。
			</label>
		</div>
		<div class="lab23-input-group">
			<label class="lab23-input-label" for="lab23_search_console_tag">Search Console</label>
			<div class="lab23-input">
				<input type="text" name="lab23_search_console_tag" id="lab23_search_console_tag" value="<?php echo get_option('lab23_search_console_tag', ''); ?>">
			</div>
			<p class="lab23-input-desc">content="この中の文字列を入力"</p>
		</div>
		<div class="lab23-input-group">
			<h3 class="lab23-input-group__heading"><?php _e( 'JSON-LDのパブリッシャー設定', 'lab23' ); ?></h3>
			<div class="lab23-input-group__item">
				<label class="lab23-input-label" for="lab23_publisher_name"><?php _e( 'パブリッシャーの「name」', 'lab23' ); ?></label>
				<div class="lab23-input">
					<input type="text" name="lab23_publisher_name" id="lab23_publisher_name" value="<?php echo get_option( 'lab23_publisher_name', '' ); ?>">
				</div>
				<p class="lab23-input-desc"><?php _e( 'JSON-LDで使用するパブリッシャーの「name」を設定。サイト運営者や組織の名前を入力さしてください。', 'lab23' ); ?></p>
			</div>
			<div class="lab23-input-group__item">
				<div class="lab23-media-uploader">
					<label class="lab23-input-label"><?php _e( 'パブリッシャーの「logo」', 'lab23' ); ?></label>
					<div class="lab23-image-preview">
						<img src="<?php echo esc_url( get_option( 'lab23_publisher_image', '' ) ); ?>" class="lab23-image-preview__img" style="max-width: 150px;">
					</div>
					<div class="lab23-input">
						<input type="text" name="lab23_publisher_image" id="lab23_publisher_image" class="lab23-meta-image regular-text" value="<?php echo esc_url( get_option( 'lab23_publisher_image', '' ) ); ?>" title="ロゴを選択">
					</div>
					<div class="lab23-media-upload-btns">
						<input type="button" class="button lab23-image-upload" value="メディアをアップロード">
						<input type="button" class="button lab23-image-reset" value="削除">
					</div>
					<p class="lab23-input-desc"><?php _e( 'JSON-LDで使用するパブリッシャーの「logo」を設定をします。サイト運営者や組織のロゴ画像。', 'lab23' ); ?></p>
				</div>
			</div>
		</div>
		<div class="lab23-input-group">
		<h3 class="lab23-input-group__heading"><?php _e( 'OGP設定', 'lab23' ); ?></h3>
			<div class="lab23-input-group__item">
				<div class="lab23-media-uploader">
					<label class="lab23-input-label">OGP画像</label>
					<div class="lab23-image-preview">
						<img src="<?php echo esc_url(get_option('lab23_home_ogp_image', '')); ?>" class="lab23-image-preview__img" style="max-width: 150px;">
					</div>
					<div class="lab23-input">
						<input type="text" name="lab23_home_ogp_image" id="lab23_home_ogp_image" class="lab23-meta-image regular-text" value="<?php echo esc_url(get_option('lab23_home_ogp_image', '')); ?>" title="OGPを選択">
					</div>
					<div class="lab23-media-upload-btns">
						<input type="button" class="button lab23-image-upload" value="メディアをアップロード">
						<input type="button" class="button lab23-image-reset" value="削除">
					</div>
					<p class="lab23-input-desc">トップページや他ページのデフォルトとして利用されます。</p>
				</div>
			</div>
			<div class="lab23-input-group__item">
				<label class="lab23-input-label" for="lab23_twitter_ogp_size">X（旧Twitter）での画像表示サイズ </label>
				<div class="lab23-input">
					<select name="lab23_twitter_ogp_size" id="lab23_twitter_ogp_size">
						<option value="summary" <?php if ($twitter_ogp_size === 'summary') echo 'selected'; ?>>小</option>
						<option value="summary_large_image" <?php if ($twitter_ogp_size === 'summary_large_image') echo 'selected'; ?>>大</option>
					</select>
				</div>
			</div>
		</div>
	</div>
</div>