<?php

function lab23_general_settings_menu_page()
{
	add_menu_page( 'Lab23共通設定画面', 'Lab23設定', 'manage_options', 'lab23_setting_page', 'lab23_add_general_settings_menu_page', 'dashicons-admin-generic', 20 );
	add_action( 'admin_init', 'lab23_register_custom_setting' );
}
add_action( 'admin_menu', 'lab23_general_settings_menu_page' );

function lab23_add_general_settings_menu_page()
{
?>
	<div class="lab23-settings-page">
		<div class="lab23-note">
			<p>デザインは<a href="<?php echo admin_url( 'customize.php' ); ?>">カスタマイズ</a>で設定できます。</p>
		</div>
		<h2 class="lab23-settings-page__ttl">Lab23 共通設定画面</h2>
		<div class="lab23-settings-form-wrap">
			<div class="lab23-settings-tabs">
				<ul class="lab23-settings-tabs-list">
					<li class="lab23-settings-tabs-list__item is-active" data-id="seo">SEO/OGP設定</li>
					<li class="lab23-settings-tabs-list__item" data-id="optimization">高速化設定</li>
					<li class="lab23-settings-tabs-list__item" data-id="tag">タグ設定</li>
				</ul>
			</div>
			<div class="lab23-settings-group">
				<form method="post" action="options.php" enctype="multipart/form-data" encoding="multipart/form-data">
					<?php
					settings_fields( 'custom-menu-group' );
					do_settings_sections( 'custom-menu-group' );
					?>
					<?php get_template_part( 'lib/theme-settings/seo' ); ?>
					<?php get_template_part( 'lib/theme-settings/optimization' ); ?>
					<?php get_template_part( 'lib/theme-settings/tag' ); ?>
					<?php submit_button(); ?>
				</form>
			</div>

		</div>
	</div>
<?php
}

function lab23_register_custom_setting()
{
	// SEO
	register_setting( 'custom-menu-group', 'lab23_meta_description', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );
	register_setting( 'custom-menu-group', 'lab23_analytics' );
	register_setting( 'custom-menu-group', 'lab23_nocount_login_user' );
	register_setting( 'custom-menu-group','lab23_search_console_tag', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );
	register_setting( 'custom-menu-group','lab23_publisher_name', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );
	register_setting( 'custom-menu-group', 'lab23_publisher_image', array(
		'sanitize_callback' => 'esc_url',
	) );
	register_setting( 'custom-menu-group', 'lab23_home_ogp_image', array(
		'sanitize_callback' => 'esc_url',
	) );
	register_setting( 'custom-menu-group', 'lab23_twitter_ogp_size' );

	// optimization
	register_setting( 'custom-menu-group', 'lab23_unset_emoji', array(
		'sanitize_callback' => 'lab23_sanitize_checkbox',
	) );
	register_setting( 'custom-menu-group', 'lab23_unuse_jquery', array(
		'sanitize_callback' => 'lab23_sanitize_checkbox',
	) );
	register_setting( 'custom-menu-group', 'lab23_lazyload_tw_insta', array(
		'sanitize_callback' => 'lab23_sanitize_checkbox',
	) );
	register_setting( 'custom-menu-group', 'lab23_adsense_available_lazyload', array(
		'sanitize_callback' => 'lab23_sanitize_checkbox',
	) );

	// tag
	register_setting( 'custom-menu-group', 'lab23_head_tag' );
	register_setting( 'custom-menu-group', 'lab23_body_top_tag' );
	register_setting( 'custom-menu-group', 'lab23_body_end_tag' );
}
