<?php

/**
 * テンプレート文章を引っ張てくるショートコード
 */
if ( ! function_exists( 'lab23_get_parts_content' ) ) {
	function lab23_get_parts_content($atts) {

		$error_msg = '<p>投稿が見つかりませんでした。</p>';
		
		if ( ! empty( $atts['id'] ) ) {

			$post_id = $atts['id'];

		} elseif ( ! empty( $atts['slug'] ) ) {

			$parts_slug = $atts['slug'];
			$post_data = get_page_by_path($parts_slug, "OBJECT", "parts");

			if ( !$post_data ) return $error_msg;

			$post_id = $post_data->ID;

		} else {

			return '';

		}

		$content = get_post_field( 'post_content', $post_id );
		
		if ( empty( $content ) ) return $error_msg;

		$content = do_shortcode($content);

		return apply_filters( 'the_content', $content );
	}
	add_shortcode( 'parts', 'lab23_get_parts_content' );
}

/**
 * アドセンス用ショートコード
 */
if ( ! function_exists( 'lab23_adsense_shortcode' ) ){
	function lab23_adsense_shortcode(){

		if ( is_singular() ) {
			$post_id = get_the_ID();
			$no_ad_value = get_post_meta( $post_id,'no_ad', true );

			if ( $no_ad_value === 'is-off' ) return '';
		}
		
		$adsense_code = get_option( 'lab23_adsense_shortcode', '' );

		if ( ! empty( $adsense_code ) ) {
			$src = false;
			$ins = false;
			if ( !empty( get_option( 'lab23_adsense_available_lazyload' ) ) ) {
				
				$adsense_code = str_replace( array("\r\n", "\r", "\n"), "", $adsense_code );

				$pattern = '/<script.*?src\s*=\s*[\"|\'](.*?)[\"|\'].*?>/i';
				if ( preg_match( $pattern, $adsense_code, $matches) ) {
					$src = $matches[1];
				}

				$pattern2 = '/<ins.*?<\/ins>/';
				if ( preg_match( $pattern2, $adsense_code, $matches) ) {
					$ins = $matches[0];
				}
			}

			if ( $src && $ins ) {
				$adcode = '<div class="adsense-wrap" data-adsrc="' . $src . '">' . $ins . '</div>';
			} else {
				$adcode = '<div class="adsense-wrap">' . $adsense_code . '</div>';
			}

			return $adcode;

		} else {

			return '';

		}
	}
	add_shortcode('ads', 'lab23_adsense_shortcode');
}