<?php
/**
 * 目次関連設定
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * 同じ見出しがあると不具合が起こるのでコメントアウトで対処
 */
function lab23_replace_same_heading( $content ) {

	$mokuji_heading_num = '3';
	$post_id 			= get_the_ID();
	$mokuji_range		= get_post_meta( $post_id, 'lab23_mokuji_range', true) ?: 'default';

	if( !empty( $mokuji_range ) && $mokuji_range !== 'default') {
		$mokuji_heading_num = $mokuji_range;
	} else {
		$mokuji_heading_num = get_option( 'lab23_mokuji_heading_num', '3' );
	}

	

	$search_pattern = '/<h([1-'. $mokuji_heading_num .'])([^>]*)>(.*?)<\/h\1>/';

	if ( preg_match_all( $search_pattern, $content, $matches,  PREG_SET_ORDER ) ) {

		$cnt = 0;

		foreach( $matches as $match ) {

			$heaging_text = str_replace( '/', '\/', $match[3] );
			$heaging_text = str_replace( '(', '\(', $heaging_text );
			$heaging_text = str_replace( ')', '\)', $heaging_text );
			$heaging_text = str_replace( '.', '\.', $heaging_text );
			$heaging_text = str_replace( '|', '\|', $heaging_text );
			$heaging_text = str_replace( '\\', '\\', $heaging_text );
			$heaging_text = str_replace( '[', '\[', $heaging_text );
			$heaging_text = str_replace( ']', '\]', $heaging_text );
			$heaging_text = str_replace( '{', '\{', $heaging_text );
			$heaging_text = str_replace( '}', '\}', $heaging_text );
			$heaging_text = str_replace( '$', '\$', $heaging_text );
			$heaging_text = str_replace( '*', '\*', $heaging_text );

			$content = preg_replace( '/<h([1-'. $mokuji_heading_num .'])([^>]*)>' . $heaging_text . '<\/h\1>/', '<h$1$2>'. $match[3] . '<!--' . $cnt . '--></h$1>', $content, 1 );
			/* $debug = preg_match('/<h([1-'. $mokuji_heading_num .'])([^>]*)>' . $heaging_text . '<\/h\1>/', $content );
			var_dump( $debug ); */
			$cnt++;
		}
	}

  return $content;
}

function lab23_get_mokuji_info( $content ) {

	$mokuji = '';
	$counter = 0;
	$mokuji_heading_num = '3';

	$post_id = get_the_ID();

	$mokuji_range = get_post_meta( $post_id, 'lab23_mokuji_range', true) ?: 'default';

	if( !empty( $mokuji_range ) && $mokuji_range !== 'default') {
		$mokuji_heading_num = $mokuji_range;
	} else {
		$mokuji_heading_num = get_option( 'lab23_mokuji_heading_num', '3' );
	}
  
	// 記事内の見出しを検索
	if ( preg_match_all( '/<h([1-'. $mokuji_heading_num .'])[^>]*>(.*?)<\/h\1>/', $content, $matches,  PREG_SET_ORDER ) ) {

		$min_level = min(array_map(function($m) { return $m[1]; }, $matches));

		$current_level = $min_level - 1;

		$sub_levels = array('1' => 0, '2' => 0, '3' => 0, '4' => 0, '5' => 0, '6' => 0);

		foreach ($matches as $m) {
			$level = $m[1];
			$text = $m[2];

			while ($current_level > $level) {
				$current_level--;
				$mokuji .= '</li></ol>';
			}
			
			if ($current_level == $level) {
				$mokuji .= '</li><li class="mokuji__item">';
			} else {

				while ($current_level < $level) {
					$current_level++;
					$mokuji .= sprintf('<ol class="mokuji__list mokuji__list-%s"><li class="mokuji__item">', $current_level);
				}
					for ($idx = $current_level + 0; $idx < count($sub_levels); $idx++) {
					$sub_levels[$idx] = 0;
				}
			}

			$sub_levels[$current_level]++;

			$level_fullpath = array();
			for ($idx = $min_level; $idx <= $level; $idx++) {
				$level_fullpath[] = $sub_levels[$idx];
			}
			$target_anchor = 'mokuji__' . implode('_', $level_fullpath);

			$mokuji .= sprintf('<a class="mokuji__link" href="#%s">%s</a>', $target_anchor, strip_tags($text));

			$hid = preg_replace('/<h([1-6])/', '<h\1 id="' .$target_anchor . '"', $m[0]);
			$content = str_replace($m[0], $hid, $content);

		}

		while ($current_level >= $min_level) {
			$mokuji .= '</li></ol>';
			$current_level--;
		}

		$counter = count($matches);
	}
	return array('content' => $content, 'mokuji' => $mokuji, 'count' => $counter);
}

//目次を作成します。
function lab23_add_mokuji($content) {

	$post_type = get_post_type();
	$has_mokuji_tag = strpos( $content, '[mokuji]' );

	if ( empty( $has_mokuji_tag ) ) {
		if ( empty( get_option( 'lab23_mokuji_auto', false ) ) ) {
			return $content;
		}

		if ( 'page' === $post_type ) {
			if ( empty( get_option( 'lab23_mokuji_auto_page', true ) ) ) {
				return $content;
			}
		}

		if ( 'post' === $post_type ) {
			if ( empty( get_option( 'lab23_mokuji_auto_post', true ) ) ) {
				return $content;
			}
		}

		// 強制的に非表示
		if( get_post_meta( get_the_ID(), 'lab23_hide_mokuji', true ) === '1' ) {
			return $content;
		}
	}

	

	// 目次を表示するために必要な見出しの数
	$number = get_option( 'lab23_mokuji_number', 1 );
	$content = lab23_replace_same_heading( $content );
	// 目次関連の情報を取得します。
	$mokuji_info = lab23_get_mokuji_info($content);
	$content = $mokuji_info['content'];
	$mokuji = $mokuji_info['mokuji'];
	$count   = $mokuji_info['count'];

	if ( get_option( 'lab23_mokuji_close' ) ) {
		$close = "";
	} else {
		$close = "checked";
	}

	$mokuji_title = get_option( 'lab23_mokuji_title', '目次' );

	//すでに目次がある場合は削除（ショートコードで生成されてしまうため）
	$pattern = '/<!-- start_mokuji -->(.*?)<!-- end_mokuji -->/s';
	$content = preg_replace( $pattern, '', $content );
	
	$shortcode_mokuji = '[mokuji]';
	$mokuji_class = !empty( get_option( 'lab23_mokuji_numbering' ) ) ? ' mokuji--numbering' : '';

	$mokuji_class .= ' mokuji--' . get_option( 'lab23_mokuji_design', 'bg-color' );

	// ボタンの表記
	$open_text	= sanitize_text_field( get_option( 'lab23_mokuji_open_text', 'open' ) );
	$close_text = sanitize_text_field( get_option( 'lab23_mokuji_close_text', 'close' ) );

	if ( empty( $open_text ) ) $open_text = 'open';
	if ( empty( $close_text ) ) $close_text = 'close';

	if ($mokuji != '' && $count >= $number) {
		// 目次を装飾
		$decorated_mokuji = sprintf('
		<!-- start_mokuji --><div class="mokuji' . $mokuji_class . '">
			<input class="mokuji__toggle" id="mokuji__toggle" type="checkbox" ' . $close . '>
			<div class="mokuji__top">
			<span class="mokuji__title">' . $mokuji_title . '</span>
			<label class="mokuji__switch" for="mokuji__toggle">
				<span class="mokuji__open-text">' . $open_text . '</span>
				<span class="mokuji__close-text">' . $close_text . '</span>
			</label>
			</div>
		%s
		</div><!-- end_mokuji -->', $mokuji);

		if (  is_singular() ) {
			if ( strpos( $content, $shortcode_mokuji ) !== false ) {
				$content = str_replace( $shortcode_mokuji, $decorated_mokuji, $content );
			} else if ( get_post_meta( get_the_ID(), 'lab23_hide_mokuji', true ) != '1' && get_option( 'lab23_mokuji_auto' ) && preg_match( '/<h[1-6].*>/', $content, $matches, PREG_OFFSET_CAPTURE ) ) {

				$pos = $matches[0][1];
				$content = substr( $content, 0, $pos ) . $decorated_mokuji . substr( $content, $pos );
			}
		}
	} else {
		$content = str_replace( $shortcode_mokuji, '', $content );
	}
	return $content;
}
add_filter( 'the_content', 'lab23_add_mokuji', 100 );
