<?php

/**
 * SEO用の設定
 */
if (!defined('ABSPATH')) {
    exit;
}

//カスタムフィールドの追加
if (!function_exists('lab23_add_seo_metabox')) {

    function lab23_add_seo_metabox()
    {
        add_meta_box('lab23_seo', __('SEO設定', 'lab23'), 'lab23_seo_metabox', array('page', 'post'), 'normal', 'default');
    }
    add_action('admin_menu', 'lab23_add_seo_metabox', 1);
}

if (!function_exists('lab23_seo_metabox')) {
    function lab23_seo_metabox()
    {
        $post_id            = get_the_ID();
        $title              = get_post_meta($post_id, 'lab23_seo_title', true);
        $remove_sitename    = get_post_meta($post_id, 'lab23_seo_title_remove_sitename', true);
        $description        = get_post_meta($post_id, 'lab23_seo_description', true);

        wp_nonce_field('wp-nonce-key', '_wp_nonce_lab23');
?>
        <div class="lab23-metabox-group">
            <div class="lab23-metabox-block">
                <div class="lab23-metabox-item">
                    <p class="lab23-metabox-label lab23-metabox-label--bold"><label for="lab23_seo_title">SEOタイトル</label></p>
                    <input type="text" name="lab23_seo_title" id="lab23_seo_title" value="<?php echo $title ?>" style="width: 100%;max-width: 500px;">
                    <p class="lab23-metabox-desc">検索向けのタイトルです。ページには表示されません。</p>

                </div>
                <div class="lab23-metabox-item">
                    <p class="lab23-metabox-label lab23-metabox-label--bold"><label for="lab23_seo_title_remove_sitename">SEOタイトルにサイト名を入れない</label></p>
                    <label>
                        <input type="checkbox" name="lab23_seo_title_remove_sitename" id="lab23_seo_title_remove_sitename" <?php if ($remove_sitename) echo 'checked'; ?>> サイト名を入れない
                    </label>
                </div>
                <div class="lab23-metabox-item">
                    <p class="lab23-metabox-label lab23-metabox-label--bold"><label for="lab23_seo_description">meta description</label></p>
                    <textarea type="text" name="lab23_seo_description" id="lab23_seo_description" style="width: 100%;height: 100px;"><?php echo $description ?></textarea>
                    <p class="lab23-metabox-desc">検索結果に表示されるページの説明文です。</p>
                </div>
            </div>
        </div>

<?php
    }
}

if (!function_exists('lab23_save_seo_metabox')) {
    function lab23_save_seo_metabox($post_id)
    {
        if (!isset($_POST['_wp_nonce_lab23']) || !$_POST['_wp_nonce_lab23']) return;
        if (!check_admin_referer('wp-nonce-key', '_wp_nonce_lab23')) return;

        lab23_save_meta_value($post_id, 'lab23_seo_title', 'lab23_seo_title');
        lab23_save_meta_boolean_value($post_id, 'lab23_seo_title_remove_sitename', 'lab23_seo_title_remove_sitename');
        lab23_save_meta_value($post_id, 'lab23_seo_description', 'lab23_seo_description');
    }
    add_action('save_post', 'lab23_save_seo_metabox');
}
