<?php

/**
 * フロントページ設定
 */
if (!defined('ABSPATH')) {
	exit;
}

//カスタムフィールドの追加
if (!function_exists('lab23_add_home_metabox')) {

	function lab23_add_home_metabox() {
		add_meta_box( 'lab23_home_settings', __( 'フロントページ設定', 'lab23' ), 'lab23_home_metabox', 'page', 'normal', 'high' );
	}
	add_action('admin_menu', 'lab23_add_home_metabox', 1);
}

if (!function_exists('lab23_home_metabox')) {
	function lab23_home_metabox()
	{
		$post_id			= get_the_ID();
		$container_bg_color = get_post_meta( $post_id, 'lab23_container_bg_color', true );
		$page_bg_color		= get_post_meta( $post_id, 'lab23_page_bg_color', true );
		$text_color			= get_post_meta( $post_id, 'lab23_page_text_color', true );
		$page_width			= get_post_meta( $post_id, 'lab23_page_width', true );
		$contents_pt		= get_post_meta($post_id, 'lab23_contents_pt', true);
		$contents_plr		= get_post_meta($post_id, 'lab23_contents_plr', true);
		$contents_pb		= get_post_meta($post_id, 'lab23_contents_pb', true);
		$contents_pt_sp		= get_post_meta($post_id, 'lab23_contents_pt_sp', true);
		$contents_plr_sp	= get_post_meta($post_id, 'lab23_contents_plr_sp', true);
		$contents_pb_sp		= get_post_meta($post_id, 'lab23_contents_pb_sp', true);
		$hide_submenu		= get_post_meta( $post_id, 'lab23_hide_submenu', true );
		$hide_information	= get_post_meta( $post_id, 'lab23_hide_information', true );

		// header
		$header_transparent				= get_post_meta( $post_id, 'lab23_header_transparent', true );
		$text_color_transparent_header	= get_post_meta( $post_id, 'lab23_text_color_transparent_header', true );

		// shadow
		$has_shadow			= get_post_meta( $post_id, 'lab23_has_shadow', true );
		$has_header			= get_post_meta( $post_id, 'lab23_has_header', true );
		$has_footer_menu	= get_post_meta( $post_id, 'lab23_has_footer_menu', true );
		$has_footer_widget	= get_post_meta( $post_id, 'lab23_has_footer_widget', true );
		$has_copyright		= get_post_meta( $post_id, 'lab23_has_copyright', true );

		wp_nonce_field('wp-nonce-key', '_wp_nonce_lab23');
?>
		<div class="lab23-metabox-group">
			<p class="lab23-metabox-desc">「フロントページ設定」は<strong>テンプレートを「トップページ用」</strong>にしている場合のみ反映されます。</p>
			<div class="lab23-metabox-flex">
				<div class="lab23-metabox-item">
					<p class="lab23-metabox-label">
						<label for="lab23_container_bg_color">ページ全体背景色</label>
					</p>
					<input type="text" name="lab23_container_bg_color" id="lab23_container_bg_color" class="add-color-picker-number-field" value="<?php echo $container_bg_color; ?>">
				</div>
				<div class="lab23-metabox-item">
					<p class="lab23-metabox-label">
						<label for="lab23_page_bg_color">コンテンツ背景色</label>
					</p>
					<input type="text" name="lab23_page_bg_color" id="lab23_page_bg_color" class="add-color-picker-number-field" value="<?php echo $page_bg_color; ?>">
				</div>
				<div class="lab23-metabox-item">
					<p class="lab23-metabox-label">
						<label for="lab23_page_text_color">テキストカラー</label>
					</p>
					<input type="text" name="lab23_page_text_color" id="lab23_page_text_color" class="add-color-picker-number-field" value="<?php echo $text_color; ?>">
				</div>
			</div>
			<div class="lab23-metabox-flex">
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label">
						<label for="lab23_page_width">コンテンツの最大幅</label>
					</p>
					<input type="number" name="lab23_page_width" id="lab23_page_width" step="1" min="0" value="<?php echo $page_width; ?>"> px
				</div>
			</div>
			<div class="lab23-metabox-flex">
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label">
						<label for="lab23_contents_pt">コンテンツ上の余白(PC)</label>
					</p>
					<input type="number" name="lab23_contents_pt" id="lab23_contents_pt" step="1" min="0" value="<?php echo $contents_pt; ?>"> px
				</div>
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label">
						<label for="lab23_contents_plr">コンテンツ左右の余白(PC)</label>
					</p>
					<input type="number" name="lab23_contents_plr" id="lab23_contents_plr" step="1" min="0" value="<?php echo $contents_plr; ?>"> px
				</div>
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label">
						<label for="lab23_contents_pb">コンテンツ下の余白(PC)</label>
					</p>
					<input type="number" name="lab23_contents_pb" id="lab23_contents_pb" step="1" min="0" value="<?php echo $contents_pb; ?>"> px
				</div>
			</div>
			<div class="lab23-metabox-flex">
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label">
						<label for="lab23_contents_pt_sp">コンテンツ上の余白(スマホ)</label>
					</p>
					<input type="number" name="lab23_contents_pt_sp" id="lab23_contents_pt_sp" step="1" min="0" value="<?php echo $contents_pt_sp; ?>"> px
				</div>
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label">
						<label for="lab23_contents_plr_sp">コンテンツ左右の余白(スマホ)</label>
					</p>
					<input type="number" name="lab23_contents_plr_sp" id="lab23_contents_plr_sp" step="1" min="0" value="<?php echo $contents_plr_sp; ?>"> px
				</div>
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label">
						<label for="lab23_contents_pb_sp">コンテンツ下の余白(スマホ)</label>
					</p>
					<input type="number" name="lab23_contents_pb_sp" id="lab23_contents_pb_sp" step="1" min="0" value="<?php echo $contents_pb_sp; ?>"> px
				</div>
			</div>
			<div class="lab23-metabox-flex">
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label"><label for="lab23_hide_submenu">サブメニュー非表示</label></p>
					<label>
						<input type="checkbox" name="lab23_hide_submenu" id="lab23_hide_submenu" <?php if ($hide_submenu) echo 'checked'; ?>> 非表示
					</label>
				</div>
				<div class="lab23-metabox-item lab23-metabox-item--20">
					<p class="lab23-metabox-label"><label for="lab23_hide_information">お知らせ非表示</label></p>
					<label>
						<input type="checkbox" name="lab23_hide_information" id="lab23_hide_information" <?php if ($hide_information) echo 'checked'; ?>> 非表示
					</label>
				</div>
			</div>
			<div class="lab23-metabox-display">
				<div class="lab23-metabox-item">
					<p class="lab23-metabox-label"><label for="lab23_has_shadow">コンテンツのシャドウ</label></p>
					<select name="lab23_has_shadow" id="lab23_has_shadow">
						<option value="default" <?php if ($has_shadow === 'default') echo 'selected'; ?>>デフォルト</option>
						<option value="has_shadow" <?php if ($has_shadow === 'has_shadow') echo 'selected'; ?>>シャドウを入れる</option>
						<option value="none" <?php if ($has_shadow === 'none') echo 'selected'; ?>>シャドウを入れない</option>
					</select>
				</div>
			</div>
			<div class="lab23-metabox-display">
				<h3 style="font-size: 14px;">フロントページヘッダー設定</h3>
				<div class="lab23-metabox-item">
					<label>
						<input type="checkbox" name="lab23_header_transparent" id="lab23_header_transparent" <?php if ( $header_transparent ) echo 'checked'; ?>> ファーストビューでヘッダーをコンテンツに重ねる
					</label>
					<p class="lab23-metabox-item__desc">※オンにした場合、サブメニューとお知らせは非表示になります。</p>
				</div>
				<?php if ( get_option( 'lab23_header_style', 'type1' ) !== 'type3' ) : ?>
					<div class="lab23-metabox-item">
						<p class="lab23-metabox-label">
							<label for="lab23_text_color_transparent_header">ヘッダーをコンテンツに重ねた時のヘッダー文字色</label>
						</p>
						<input type="text" name="lab23_text_color_transparent_header" id="lab23_text_color_transparent_header" class="add-color-picker-number-field" value="<?php echo $text_color_transparent_header; ?>">
					</div>
				<?php endif; ?>
			</div>
			
		</div>
<?php
	}
}

if (!function_exists('lab23_save_page_metabox')) {
	function lab23_save_page_metabox($post_id)
	{
		if ( ! isset($_POST['_wp_nonce_lab23']) || ! $_POST['_wp_nonce_lab23'] ) return;
		if ( ! check_admin_referer( 'wp-nonce-key', '_wp_nonce_lab23' ) ) return;

		lab23_save_meta_value( $post_id, 'lab23_container_bg_color', 'lab23_container_bg_color' );
		lab23_save_meta_value( $post_id, 'lab23_page_bg_color', 'lab23_page_bg_color' );
		lab23_save_meta_value( $post_id, 'lab23_page_text_color', 'lab23_page_text_color' );
		lab23_save_meta_value( $post_id, 'lab23_page_width', 'lab23_page_width' );
		lab23_save_meta_value( $post_id, 'lab23_has_shadow', 'lab23_has_shadow' );
		lab23_save_meta_value($post_id, 'lab23_contents_pt', 'lab23_contents_pt');
		lab23_save_meta_value($post_id, 'lab23_contents_plr', 'lab23_contents_plr');
		lab23_save_meta_value($post_id, 'lab23_contents_pb', 'lab23_contents_pb');
		lab23_save_meta_value($post_id, 'lab23_contents_pt_sp', 'lab23_contents_pt_sp');
		lab23_save_meta_value($post_id, 'lab23_contents_plr_sp', 'lab23_contents_plr_sp');
		lab23_save_meta_value($post_id, 'lab23_contents_pb_sp', 'lab23_contents_pb_sp');
		lab23_save_meta_boolean_value( $post_id, 'lab23_hide_submenu', 'lab23_hide_submenu' );
		lab23_save_meta_boolean_value( $post_id, 'lab23_hide_information', 'lab23_hide_information' );
		lab23_save_meta_boolean_value( $post_id, 'lab23_header_transparent', 'lab23_header_transparent' );
		lab23_save_meta_value( $post_id, 'lab23_text_color_transparent_header', 'lab23_text_color_transparent_header' );
	}
	add_action( 'save_post', 'lab23_save_page_metabox' );
}
