<?php

/**
 * 検索除外設定
 */
if (!defined('ABSPATH')) {
    exit;
}

//カスタムフィールドの追加
if (!function_exists('lab23_add_exclude_search_metabox')) {

    function lab23_add_exclude_search_metabox()
    {
        add_meta_box('lab23_exclude_search', __('サイト内検索設定', 'lab23'), 'lab23_exclude_search_metabox', array('page'), 'normal', 'default');
    }
    add_action('admin_menu', 'lab23_add_exclude_search_metabox', 1);
}

if (!function_exists('lab23_exclude_search_metabox')) {
    function lab23_exclude_search_metabox()
    {
        $post_id        = get_the_ID();
        $exclude_search = get_post_meta($post_id, 'lab23_exclude_search', true);

        wp_nonce_field('wp-nonce-key', '_wp_nonce_lab23');
?>
        <div class="lab23-metabox-group">
            <div class="lab23-metabox-block">
                <div class="lab23-metabox-item">
                    <p class="lab23-metabox-label lab23-metabox-label--bold"><label for="lab23_exclude_search">サイト内検索から除外</label></p>
                    <label>
                        <input type="checkbox" name="lab23_exclude_search" id="lab23_exclude_search" <?php if ($exclude_search) echo 'checked'; ?>> このページをサイト内検索にヒットさせない
                    </label>
                </div>
            </div>
        </div>

<?php
    }
}

if (!function_exists('lab23_save_exclude_search_metabox')) {
    function lab23_save_exclude_search_metabox($post_id)
    {
        if (!isset($_POST['_wp_nonce_lab23']) || !$_POST['_wp_nonce_lab23']) return;
        if (!check_admin_referer('wp-nonce-key', '_wp_nonce_lab23')) return;

        lab23_save_meta_boolean_value($post_id, 'lab23_exclude_search', 'lab23_exclude_search');
    }
    add_action('save_post', 'lab23_save_exclude_search_metabox');
}
