<?php

/**
 * 固定ページの投稿
 */
if (!defined('ABSPATH')) {
    exit;
}

//カスタムフィールドの追加
if (!function_exists('lab23_add_disable_entry_header_metabox')) {

    function lab23_add_disable_entry_header_metabox()
    {
        add_meta_box( 'lab23_disable_entry_header', __('投稿上部の表示設定', 'lab23'), 'lab23_disable_entry_header_metabox', array( 'page' ), 'normal', 'default' );
    }
    add_action('admin_menu', 'lab23_add_disable_entry_header_metabox', 1);
}

if (!function_exists('lab23_disable_entry_header_metabox')) {
    function lab23_disable_entry_header_metabox()
    {
        $post_id        = get_the_ID();
        $disable_entry_header = get_post_meta( $post_id, 'lab23_disable_entry_header', true );

        wp_nonce_field('wp-nonce-key', '_wp_nonce_lab23');
?>
        <div class="lab23-metabox-group">
            <div class="lab23-metabox-block">
                <div class="lab23-metabox-item">
                    <p class="lab23-metabox-label lab23-metabox-label--bold"><label for="lab23_disable_entry_header">投稿上部のタイトルやシェアボタンを非表示にする</label></p>
                    <label>
                        <input type="checkbox" name="lab23_disable_entry_header" id="lab23_disable_entry_header" <?php if ($disable_entry_header) echo 'checked'; ?>> 非表示
                    </label>
                </div>
            </div>
        </div>

<?php
    }
}

if (!function_exists('lab23_save_disable_entry_header_metabox')) {
    function lab23_save_disable_entry_header_metabox($post_id)
    {
        if ( ! isset($_POST['_wp_nonce_lab23']) || ! $_POST['_wp_nonce_lab23'] ) return;
        if ( ! check_admin_referer( 'wp-nonce-key', '_wp_nonce_lab23' ) ) return;

        lab23_save_meta_boolean_value( $post_id, 'lab23_disable_entry_header', 'lab23_disable_entry_header' );
    }
    add_action('save_post', 'lab23_save_disable_entry_header_metabox');
}
