<?php

/**
 * パンくずリストの表示設定
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

//カスタムフィールドの追加
if ( ! function_exists( 'lab23_add_breadcrumbs_metabox' ) ) {

    function lab23_add_breadcrumbs_metabox() {
        add_meta_box( 'lab23_breadcrumbs_display', __( 'パンくずリスト表示設定', 'lab23' ), 'lab23_breadcrumbs_metabox', array( 'page', 'post' ), 'normal', 'default' );
    }
    add_action( 'admin_menu', 'lab23_add_breadcrumbs_metabox', 1 );
}

if ( !function_exists( 'lab23_breadcrumbs_metabox' ) ) {
    function lab23_breadcrumbs_metabox() {
        $post_id			= get_the_ID();
        $breadcrumbs_settings	= get_post_meta( $post_id, 'lab23_breadcrumbs_display', true );

        wp_nonce_field( 'wp-nonce-key', '_wp_nonce_lab23' );
?>
        <div class="lab23-metabox-group">
			<div class="lab23-metabox-block">
				<div class="lab23-metabox-item">
					<p class="lab23-metabox-label"><label for="lab23_breadcrumbs_display">パンくずリストの表示</label></p>
					<select name="lab23_breadcrumbs_display" id="lab23_breadcrumbs_display">
						<option value="default" <?php if ( $breadcrumbs_settings === 'default' ) echo 'selected'; ?>>デフォルト</option>
						<option value="show" <?php if ( $breadcrumbs_settings === 'show' ) echo 'selected'; ?>>表示</option>
						<option value="hide" <?php if ( $breadcrumbs_settings === 'hide' ) echo 'selected'; ?>>非表示</option>
					</select>
				</div>
			</div>
        </div>

<?php
    }
}

if ( ! function_exists( 'lab23_save_advertisement_tag_metabox' ) ) {
    function lab23_save_advertisement_tag_metabox( $post_id)
    {
        if ( ! isset( $_POST['_wp_nonce_lab23']) || ! $_POST['_wp_nonce_lab23'] ) return;
        if ( ! check_admin_referer( 'wp-nonce-key', '_wp_nonce_lab23' ) ) return;

        lab23_save_meta_value( $post_id, 'lab23_breadcrumbs_display', 'lab23_breadcrumbs_display' );
    }
    add_action( 'save_post', 'lab23_save_advertisement_tag_metabox' );
}
