<?php

/**
 * メニューの設定
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'lab23_setup_nav' ) ) {
	function lab23_setup_nav() {
		register_nav_menus(array(
			'global'		=> 'グローバルナビ（PC）',
			'sp-global'		=> 'グローバルナビ（スマホ）',
			'sub-menu'		=> 'サブメニュー',
			'footer'		=> 'フッターナビ',
		));
	}
}
add_action('after_setup_theme', 'lab23_setup_nav');

function lab23_prefix_nav_description( $item_output, $item, $depth, $args ) {
	if ( $args->theme_location === 'global' && !empty( $item->description ) ) {
		$item_output = str_replace( '">' . $args->link_before . $item->title, '">' . $args->link_before . '<span class="menu-item__name">' . $item->title . '</span>' . '<span class="menu-item__desc">' . $item->description . '</span>' , $item_output );
	}
	return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'lab23_prefix_nav_description', 10, 4 );
