<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * テーマの初期設定
 */

if (!function_exists('lab23_initial_setup')) {
	
	function lab23_initial_setup()
	{
		add_theme_support( 'custom-background', array('default-color' => '#f7f7f7',));
		// タイトルを自動出力
		add_theme_support( 'title-tag' );

		// アイキャッチ機能を使用
		add_theme_support( 'post-thumbnails' );

		// 埋め込みのレスポンシブ自動対応
		add_theme_support( 'responsive-embeds' );

        // feedの生成
        add_theme_support( 'automatic-feed-links' );

        // 抜粋のサポート
        add_theme_support( 'excerpt' );

		add_theme_support( 'align-wide' );

		add_theme_support(
			'html5',
			array(
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'search-form',
				'navigation-widgets',
			)
		);

		add_theme_support( 'wp-block-styles' );

		add_theme_support( 'editor-styles' );

		add_theme_support( 'customize-selective-refresh-widgets' );

		add_theme_support( 'custom-line-height' );

		add_theme_support( 'experimental-link-color' );

		add_theme_support( 'custom-spacing' );

		add_theme_support( 'custom-header', array(
			'width'			=> 1600,
			'height'		=> 990,
			'header-text'	=> false,
			'flex-height'	=> true,
			'flex-width'	=> true,
			'video'			=> true,
		) );

		add_filter('rss_widget_feed_link', '__return_false' );

		//rel="prev"とrel="next"の非表示
		remove_action('wp_head', 'adjacent_posts_rel_link_wp_head' );
		//WordPressのバージョンの非表示
		remove_action('wp_head', 'wp_generator' );

		//絵文字の非表示
		if( ! empty( get_option( 'lab23_unset_emoji' ) ) ) {
			remove_action('wp_head', 'print_emoji_detection_script', 7);
			remove_action('wp_print_styles', 'print_emoji_styles' );
		}

		add_editor_style( 'assets/css/editor-style.css' );
	}
}
add_action('after_setup_theme', 'lab23_initial_setup' );
