<?php

if ( ! function_exists( 'lab23_infeed_ad_html' ) ) {
	function lab23_infeed_ad_html( $adsense_code ) {

		$src = false;
		$ins = false;
		if ( ! empty( get_option( 'lab23_adsense_available_lazyload' ) ) ) {
		
			$adsense_code = str_replace( array("\r\n", "\r", "\n"), "", $adsense_code );

			$pattern = '/<script.*?src\s*=\s*[\"|\'](.*?)[\"|\'].*?>/i';
			if ( preg_match( $pattern, $adsense_code, $matches) ) {
				$src = $matches[1];
			}

			$pattern2 = '/<ins.*?<\/ins>/';
			if ( preg_match( $pattern2, $adsense_code, $matches) ) {
				$ins = $matches[0];
			}
		}

		if ( $src && $ins ) {
			$adcode = '<div class="infeed-ad" data-adsrc="' . $src . '">' . $ins . '</div>';
		} else {
			$adcode = '<div class="infeed-ad">' . $adsense_code . '</div>';
		}
		return $adcode;
	}
}