<?php

if ( ! function_exists( 'lab23_get_heading_type_classname' ) ) {
	function lab23_get_heading_type_classname( $classname = '' ) {

		if ( $classname !== '' ) $classname .= ' ';

		$h2_style = get_option( 'lab23_heading_h2_style', 'type0' );
		$classname .= 'p-entry-content--h2-style-' . $h2_style;

		$h3_style = get_option( 'lab23_heading_h3_style', 'type0' );
		$classname .= ' p-entry-content--h3-style-' . $h3_style;

		$h4_style = get_option( 'lab23_heading_h4_style', 'type0' );
		$classname .= ' p-entry-content--h4-style-' . $h4_style;

		$h5_style = get_option( 'lab23_heading_h5_style', 'type0' );
		$classname .= ' p-entry-content--h5-style-' . $h5_style;

		$h6_style = get_option( 'lab23_heading_h6_style', 'type0' );
		$classname .= ' p-entry-content--h6-style-' . $h6_style;

		return $classname;
	}
}

if ( ! function_exists( 'lab23_get_body_classname' ) ) {
	function lab23_get_body_classname( $class = '' ) {

		$design_type = get_option( 'lab23_global_design_type', 'normal' );
		$classname = 'p-design-' . $design_type;

		$header_type = get_option( 'lab23_header_style', 'type1' );
		$classname .= ' l-header-style-' . $header_type;

		if ( is_home() && get_option( 'lab23_top_animation', false ) ) {
			$classname .= ' p-page-has-animation';
		}

		$widget_design = get_option( 'lab23_mainarea_widget_heading_design', 'default' );

		if ( is_string( $widget_design ) ) {
			$classname .= ' p-widget-heading-type-' . $widget_design;
		}

		if ( ! empty( $class ) ) {
			$classname .= ' ' . $class;
		}

		return $classname;
	}
}

if ( ! function_exists( 'lab23_get_header_classname' ) ) {
	function lab23_get_header_classname() {

		$header_class = 'l-header';

		$has_shadow = get_option('lab23_header_shadow', false);
		$is_fixed = get_option('lab23_header_fixed', false);

		if ( $has_shadow ) {
			$header_class .= ' l-header--shadow';
		}

		if ( $is_fixed ) {
			$header_class .= ' l-header--fixed';
		}

		global $template;

		$temp_name = basename($template);

		if ( is_page() && $temp_name === 'page-front.php' ) {
			$post_id = get_the_ID();
			$header_transparent	= get_post_meta( $post_id, 'lab23_header_transparent', true );

			if ( $header_transparent ) {
				$header_class .= ' l-header--transparent';
			}
		}

		return $header_class;
	}
}