<?php

// 本文中にアドセンス表示
function lab23_add_ads_before_heading( $content ) {

	if ( ! is_singular() ) return $content;

	if ( empty( $ads = get_option( 'lab23_adsense_auto_post_code' ) ) ) return $content;

	$post_type = get_post_type();

	if ( ! empty ( get_option( 'lab23_adsense_auto_post_type' ) ) ) {
		//固定ページも含む
		$post_type_bool = $post_type === 'page' || $post_type === 'post';
	} else {
		//固定ページは含まない
		$post_type_bool = $post_type === 'post';
	}

	if ( $post_type_bool ) {

		$post_id = get_the_ID();
		$hide_ad_value = get_post_meta( $post_id, 'no_ad', true );

		if ( $hide_ad_value === 'is-off' ) return $content;

		$count_h_list = array();

		if ( ! empty( get_option( 'lab23_adsense_include_h2', true ) ) ) array_push( $count_h_list, "2" );
		if ( ! empty( get_option( 'lab23_adsense_include_h3', true ) ) ) array_push( $count_h_list, "3" );
		if ( ! empty( get_option( 'lab23_adsense_include_h4', true ) ) ) array_push( $count_h_list, "4" );
		if ( ! empty( get_option( 'lab23_adsense_include_h5', true ) ) ) array_push( $count_h_list, "5" );
		if ( ! empty( get_option( 'lab23_adsense_include_h6', true ) ) ) array_push( $count_h_list, "6" );

		$count_h_list = implode( '|', $count_h_list );
		
		if ( empty( $count_h_list ) ) return $content;
		/**
		 * 全く同じ見出しがあるとバグるのでdata属性を入れてかぶらないようにする
		 */
		$heading_replace_regex = "/(<[hH][$count_h_list].*?)(>.*<\/[hH][$count_h_list]>)/";
		
		$num = 1;
		$content = preg_replace_callback(
			$heading_replace_regex,
			function( $matches ) use ( &$num ) {
				$result = $matches[1] . ' data-h-num="heading-' . $num . '" ' . $matches[2];
				$num++;
				return $result;
			},
			$content
		);
		$heading_regex = "/<[hH][$count_h_list].*?>.*<\/[hH][$count_h_list]>/";

		if ( preg_match_all( $heading_regex, $content, $headings ) ) {

			$first_pos = !empty( get_option( 'lab23_adsense_auto_post_first' ) ) ? get_option( 'lab23_adsense_auto_post_first' ) : '1';
			$freq_pos = !empty( get_option( 'lab23_adsense_auto_post_pos' ) ) ? get_option( 'lab23_adsense_auto_post_pos' ) : '5';

			$first_pos = $first_pos - 1;

			$insert_post = $first_pos;

			$src = false;
			$ins = false;

			if ( !empty( get_option( 'lab23_adsense_available_lazyload' ) ) ) {
				
				$ads = str_replace( array("\r\n", "\r", "\n"), "", $ads );

				$pattern = '/<script.*?src\s*=\s*[\"|\'](.*?)[\"|\'].*?>/i';
				if ( preg_match( $pattern, $ads, $matches) ) {
					$src = $matches[1];
				}

				$pattern2 = '/<ins.*?<\/ins>/';
				if ( preg_match( $pattern2, $ads, $matches) ) {
					$ins = $matches[0];
				}
			}

			if ( $src && $ins ) {
				$adcode = '<div class="adsense-wrap" data-adsrc="' . $src . '">' . $ins . '</div>';
			} else {
				$adcode = '<div class="adsense-wrap">' . $ads . '</div>';
			}

			if ( $headings[0] ) {

				$headings_array = $headings[0];

				$heading_num = count( $headings_array );

				for ( $i = 0; $i<$heading_num; $i++ ) {

					if ( $i === $insert_post ) {

						if ( $headings_array[$i] ) {
							$content  = str_replace($headings_array[$i], $adcode.$headings_array[$i], $content);
						}

						$insert_post += $freq_pos;
					}
				}
			}
		}
	}
	return $content;
}
add_filter( 'the_content', 'lab23_add_ads_before_heading', 20 );
