<?php


/**
 * CSSとJavaScriptの読み込み
 */
if ( ! function_exists( 'lab23_enqueue_scripts' ) ) {
	function lab23_enqueue_scripts() {

		$style_depth = array();

		$font = get_option( 'lab23_font_family', 'hiragino' );

		switch ($font) {
			case 'noto-sans-jp':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@400;500;700&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'noto-serif-jp':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Noto+Serif+JP:wght@400;500;700&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'm-plus':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=M+PLUS+1p:wght@400;500;700&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'm-plus-rounded':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=M+PLUS+Rounded+1c:wght@400;500;700&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'zen-old-mincho':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Zen+Old+Mincho:wght@400;500;700&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'zen-maru-gothic':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Zen+Maru+Gothic:wght@400;500;700&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'zen-kurenaido':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Zen+Kurenaido&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'kaisei-opti':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Kaisei+Opti:wght@400;500;700&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'yuji-syuku':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Yuji+Syuku&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'klee-one':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Klee+One:wght@400;600&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'yomogi':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Yomogi&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			case 'hachi-maru-pop':
				wp_enqueue_style( 'lab23-font-style', 'https://fonts.googleapis.com/css2?family=Hachi+Maru+Pop&family=Noto+Sans+JP:wght@100..900&family=Noto+Serif+JP:wght@200..900&display=swap', array() );
				$style_depth = array('lab23-font-style');
				break;

			default:
				# code...
				break;
		}

		wp_enqueue_style( 'lab23-theme-style', LAB23_TEMPLATE_URI . '/assets/css/theme.css', $style_depth, LAB23_THEME_VERSION );

		wp_enqueue_script( 'lab23-theme-script', LAB23_TEMPLATE_URI . '/assets/js/script.js', array(), LAB23_THEME_VERSION, true );

		if ( is_home() ) {
			wp_enqueue_script( 'lab23-slider-script', LAB23_TEMPLATE_URI . '/assets/js/slider.js', array(), LAB23_THEME_VERSION, true );
			wp_enqueue_style( 'lab23-slider-style', LAB23_TEMPLATE_URI . '/assets/css/slider.css', array(), LAB23_THEME_VERSION );
			wp_enqueue_style( 'lab23-top-style', LAB23_TEMPLATE_URI . '/assets/css/top.css', array(), LAB23_THEME_VERSION );
		}

		if ( ! empty( get_option( 'lab23_lazyload_tw_insta', false ) ) ) {
			wp_enqueue_script( 'lab23-lazy-load', LAB23_TEMPLATE_URI . '/assets/js/twLazyLoad.js', array(), LAB23_THEME_VERSION, true );
		}
		if ( ! empty( get_option( 'lab23_adsense_available_lazyload', false ) ) ) {
			wp_enqueue_script( 'lab23-lazy-load-ad', LAB23_TEMPLATE_URI . '/assets/js/adLazyLoad.js', array(), LAB23_THEME_VERSION, true );
		}

		if (is_single() && comments_open() && get_option('thread_comments')) {
			wp_enqueue_script( 'comment-reply' );
		} else {
			wp_deregister_script('comment-reply');
		}
	}
	add_action('wp_enqueue_scripts', 'lab23_enqueue_scripts');
}


function lab23_add_admin_style()
{
	wp_enqueue_media();
	wp_enqueue_style( 'thickbox' );
	wp_enqueue_style( 'wp-color-picker' );
	wp_enqueue_script( 'wp-color-picker' );
	wp_enqueue_style( 'admin-style', LAB23_TEMPLATE_URI . '/assets/css/admin.css', array('wp-color-picker'), LAB23_THEME_VERSION );
	wp_enqueue_script( 'admin-script', LAB23_TEMPLATE_URI . '/assets/js/admin-script.js', array('wp-color-picker'), LAB23_THEME_VERSION, true );
}
add_action('admin_enqueue_scripts', 'lab23_add_admin_style');

if (!function_exists('lab23_enqueue_style')) {
	function lab23_enqueue_style($hook_suffix)
	{
		if ($hook_suffix === 'post.php' || $hook_suffix === 'post-new.php') {

			global $post;

			if ($post->post_type !== 'page') return;

			$post_id	= $post->ID;
			$data		= '';

			$text_color	= get_post_meta($post_id, 'lab23_contents_text_color', true);

			if ($text_color) :
				ob_start();
			?>
.editor-styles-wrapper { color: <?php echo $text_color ?>;}
			<?php
				$data = ob_get_contents();
				ob_end_clean();
			endif;

			if (empty($data)) return;

			wp_add_inline_style('admin-style', $data);
		}
	}
	add_action('admin_enqueue_scripts', 'lab23_enqueue_style');
}


/**
 * 設定でjQueryを削除
 */
if( get_option( 'lab23_unuse_jquery' ) &&
	! is_admin( ) &&
	! is_customize_preview() &&
	! function_exists( 'lab23_delete_local_jquery'
) ) {
	function lab23_delete_local_jquery() {
		wp_deregister_script('jquery');
	}
	add_action( 'wp_enqueue_scripts', 'lab23_delete_local_jquery' );
}