<?php
/**
 * カスタマイザーの設定
 */
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

if( ! function_exists( 'lab23_customizer_register_top' ) ) {
	function lab23_customizer_register_top( $wp_customize ) {
		/**
		 * パネルの追加 =========================================================
		 */
		$wp_customize->add_panel( 'lab23_toppage_panel', array(
			'title'		=> __( '[Lab23]トップページの設定', 'lab23' ),
			'priority'	=> 100,
			'description'	=> __( 'トップページを最新の投稿にしている場合に反映されます。固定ページにしている場合は投稿一覧ページに反映されます。', 'lab23' ),
		));
		/**
		 * Animation
		 */
		/*
		$wp_customize->add_section( 'lab23_section_top_animation', array(
			'title'			=> __( 'トップページのアニメーション', 'lab23' ),
			'panel'			=> 'lab23_toppage_panel',
			'description'	=> __( 'トップページをアニメーションで表示させます', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_top_animation', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_top_animation', array(
			'label'		=> __( 'トップページをアニメーションで表示', 'lab23' ),
			'section'	=> 'lab23_section_top_animation',
			'settings'	=> 'lab23_top_animation',
			'type'		=> 'checkbox',
		) );
		*/

		/**
		 * Header Image
		 */
		$homepage_settings_url = admin_url('customize.php?autofocus[section]=static_front_page'); 
		$header_image_settings_url = admin_url('customize.php?autofocus[section]=header_image'); 
		$wp_customize->add_section( 'lab23_section_header_image', array(
			'title'			=> __( 'ヘッダー画像の設定', 'lab23' ),
			'panel'			=> 'lab23_toppage_panel',
			'description'	=> __( '<b><a href="' . esc_url($header_image_settings_url) . '">ヘッダー画像</a>が設定されていないと反映されません。</b><br><br>このヘッダー画像の設定は<a href="' . esc_url($homepage_settings_url) . '">「ホームページの表示」</a>が<b>「最新の投稿」</b>を指定している場合と、<b>「固定ページ」</b>を指定している場合は<b>「投稿ページ」</b>に指定したページ</i>で表示されます。<hr>', 'lab23' )
		) );
		$wp_customize->add_setting( 'lab23_header_image_max_height', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_header_image_max_height', array(
			'label'			=> __( 'ヘッダー画像の最大高さ', 'lab23' ),
			'description'	=> __( 'ヘッダー画像が大きくなりすぎないように、最大の高さを設定できます。', 'lab23' ),
			'section'		=> 'lab23_section_header_image',
			'settings'		=> 'lab23_header_image_max_height',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '1',
			),
		) );
		// ヘッダー画像にのせるカラー
		$wp_customize->add_setting( 'lab23_header_image_wrapper_color', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'lab23_header_image_wrapper_color', array(
			'label'		=> __( 'ヘッダー画像にのせる半透明カラー', 'lab23' ),
			'section'	=> 'lab23_section_header_image',
			'settings'	=> 'lab23_header_image_wrapper_color',
		)) );
		// のせるカラーの不透明度
		$wp_customize->add_setting( 'lab23_header_image_wrapper_opacity', array(
			'type'				=> 'option',
			'default'			=> '0.5',
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_header_image_wrapper_opacity', array(
			'label'			=> __( 'ヘッダー画像にのせる半透明カラーの透明度', 'lab23' ),
			'description'	=> __( '0から1.0の範囲で指定できます。', 'lab23' ),
			'section'		=> 'lab23_section_header_image',
			'settings'		=> 'lab23_header_image_wrapper_opacity',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '0.1',
				'min'	=> '0',
				'max'	=> '1.0',
			),
		) );
		// ヘッダー画像にのせるテキスト
		$wp_customize->add_setting( 'lab23_header_image_text', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_textarea_field',
		) );
		$wp_customize->add_control( 'lab23_header_image_text', array(
			'label'			=> __( 'ヘッダー画像にのせるテキスト', 'lab23' ),
			'description'	=> __( '改行は反映されます。', 'lab23' ),
			'section'		=> 'lab23_section_header_image',
			'settings'		=> 'lab23_header_image_text',
			'type'			=> 'textarea',
		) );
		// ヘッダー画像にのせるカラー
		$wp_customize->add_setting( 'lab23_header_image_text_color', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'lab23_header_image_text_color', array(
			'label'		=> __( 'テキストの文字色', 'lab23' ),
			'section'	=> 'lab23_section_header_image',
			'settings'	=> 'lab23_header_image_text_color',
		)) );
		$wp_customize->add_setting( 'lab23_header_image_font_size', array(
			'type'				=> 'option',
			'default'			=> '3',
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_header_image_font_size', array(
			'label'			=> __( 'テキストのサイズ（単位vw）', 'lab23' ),
			'description'	=> __( 'vwは画面の幅に比例する単位です（デフォルト:3vw）', 'lab23' ),
			'section'		=> 'lab23_section_header_image',
			'settings'		=> 'lab23_header_image_font_size',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '0.1',
				'min'	=> '1',
				'max'	=> '8',
			),
		) );
		$wp_customize->add_setting( 'lab23_header_image_font_size_min', array(
			'type'				=> 'option',
			'default'			=> '14',
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_header_image_font_size_min', array(
			'label'			=> __( 'テキストの最小サイズ（単位px）', 'lab23' ),
			'description'	=> __( 'フォントが小さくなりすぎないように、最小サイズを設定できます。（デフォルト:14px）', 'lab23' ),
			'section'		=> 'lab23_section_header_image',
			'settings'		=> 'lab23_header_image_font_size_min',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '10',
				'max'	=> '30',
			),
		) );
		$wp_customize->add_setting( 'lab23_header_image_font_size_max', array(
			'type'				=> 'option',
			'default'			=> '34',
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_header_image_font_size_max', array(
			'label'			=> __( 'テキストの最大サイズ（単位px）', 'lab23' ),
			'description'	=> __( 'フォントが大きくなりすぎないように、最大サイズを設定できます。（デフォルト:34px）', 'lab23' ),
			'section'		=> 'lab23_section_header_image',
			'settings'		=> 'lab23_header_image_font_size_max',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '10',
				'max'	=> '80',
			),
		) );
		/**
		 * Slider
		 */
		$wp_customize->add_section( 'lab23_section_slider', array(
			'panel'			=> 'lab23_toppage_panel',
			'title'			=> __( 'スライダー', 'lab23' ),
			'description'	=> __( 'トップページのスライダーに表示する記事の設定<br><br>このスライダーは<a href="' . esc_url($homepage_settings_url) . '">「ホームページの表示」</a>が<b>「最新の投稿」</b>を指定している場合と、<b>「固定ページ」</b>を指定している場合は<b>「投稿ページ」</b>に指定したページ</i>で表示されます。<hr>', 'lab23' )
		) );
		$wp_customize->add_setting( 'lab23_slider_id_list', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_slider_id_list', array(
			'label'			=> __( '投稿ID', 'lab23' ),
			'description'	=> __( 'スライダーに表示する記事のIDをコンマ区切りで記述してください。<br>例：1,5,12,30<br><br>※記事は必ず4記事以上設定してください。', 'lab23' ),
			'section'	=> 'lab23_section_slider',
			'settings'	=> 'lab23_slider_id_list',
			'type'		=> 'text',
		) );
		$wp_customize->add_setting( 'lab23_pickup_entry_date', array(
			'type'				=> 'option',
			'default'			=> 'post',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_pickup_entry_date', array(
			'label'		=> 'スライドの日付',
			'section'	=> 'lab23_section_slider',
			'settings'	=> 'lab23_pickup_entry_date',
			'type'		=> 'radio',
			'choices'	=> array(
				'post'		=> '投稿日',
				'update'	=> '最終更新日',
				'none'		=> '日付なし',
			),
		) );
	}
	add_action( 'customize_register', 'lab23_customizer_register_top' );
}
