<?php

/**
 * カスタマイザーの設定
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'lab23_customizer_register_post' ) ) {
	function lab23_customizer_register_post($wp_customize) {

		/**
		 * パネルの追加 =========================================================
		 */
		$wp_customize->add_panel('lab23_postpage_panel', array(
			'title'     => __( '[Lab23]投稿・固定ページの設定', 'lab23' ),
			'priority'  => 100,
		) );
		/**
		 * パンくずリストの設定
		 */
		$wp_customize->add_section( 'lab23_section_breadcrumbs', array(
			'title'    => __( 'パンくずリストの設定', 'lab23' ),
			'panel'    => 'lab23_postpage_panel',
		) );
		$wp_customize->add_setting( 'lab23_hide_breadcrumbs_post', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_hide_breadcrumbs_post', array(
			'label'		=> __( '投稿ページのパンくずリストを非表示にする', 'lab23' ),
			'section'	=> 'lab23_section_breadcrumbs',
			'settings'	=> 'lab23_hide_breadcrumbs_post',
			'type'		=> 'checkbox',
		) );
		$wp_customize->selective_refresh->add_partial('lab23_hide_breadcrumbs_post', array(
			'selector' => '#breadcrumbs',
		) );
		$wp_customize->add_setting( 'lab23_hide_breadcrumbs_page', array(
			'type'                => 'option',
			'sanitize_callback' => 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_hide_breadcrumbs_page', array(
			'label'		=> __( '固定ページのパンくずリストを非表示にする', 'lab23' ),
			'section'	=> 'lab23_section_breadcrumbs',
			'settings'	=> 'lab23_hide_breadcrumbs_page',
			'type'		=> 'checkbox',
		) );
		$wp_customize->selective_refresh->add_partial('lab23_hide_breadcrumbs_page', array(
			'selector' => '#breadcrumbs-page',
		) );
		/**
		 * フォントサイズ
		 */
		$wp_customize->add_section( 'lab23_section_font_size', array(
			'title'			=> __( 'フォントサイズ', 'lab23' ),
			'panel'			=> 'lab23_postpage_panel',
			'description'	=> __( '記事のフォントサイズ', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_font_size_title', array(
			'type'				=> 'option',
			'default'			=> '26',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_title', array(
			'label'			=> __( '記事タイトルの文字サイズ（PC)', 'lab23' ),
			'description'	=> __( '16〜40pxの範囲で指定できます。（デフォルト:26px）', 'lab23' ),
			'section'		=> 'lab23_section_font_size',
			'settings'		=> 'lab23_font_size_title',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '16',
				'max'	=> '40',
			),
		) );
		$wp_customize->selective_refresh->add_partial('lab23_font_size_title', array(
			'selector' => '#entry-title',
		) );
		$wp_customize->add_setting( 'lab23_font_size_title_sp', array(
			'type'				=> 'option',
			'default'			=> '24',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_title_sp', array(
			'label'			=> __( '記事タイトルの文字サイズ（スマホ)', 'lab23' ),
			'description'	=> __( '16〜30pxの範囲で指定できます。（デフォルト:24px）', 'lab23' ),
			'section'		=> 'lab23_section_font_size',
			'settings'		=> 'lab23_font_size_title_sp',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '16',
				'max'	=> '30',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_post', array(
			'type'				=> 'option',
			'default'			=> '16',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_post', array(
			'label'			=> __( '本文の文字サイズ', 'lab23' ),
			'description'	=> __( '12〜20pxの範囲で指定できます。（デフォルト:16px）', 'lab23' ),
			'section'		=> 'lab23_section_font_size',
			'settings'		=> 'lab23_font_size_post',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '12',
				'max'	=> '20',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_post_sp', array(
			'type'				=> 'option',
			'default'			=> '16',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_post_sp', array(
			'label'			=> __( '本文の文字サイズ（スマホ）', 'lab23' ),
			'description'	=> __( '12〜20pxの範囲で指定できます。（デフォルト:16px）', 'lab23' ),
			'section'		=> 'lab23_section_font_size',
			'settings'		=> 'lab23_font_size_post_sp',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '12',
				'max'	=> '20',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h2', array(
			'type'                => 'option',
			'default'            => '22',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h2', array(
			'label'            => __( '見出し2の文字サイズ', 'lab23' ),
			'description'    => __( '18〜30pxの範囲で指定できます。（デフォルト:22px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h2',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '18',
				'max'    => '30',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h2_sp', array(
			'type'                => 'option',
			'default'            => '22',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h2_sp', array(
			'label'            => __( '見出し2の文字サイズ（スマホ）', 'lab23' ),
			'description'    => __( '18〜30pxの範囲で指定できます。（デフォルト:22px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h2_sp',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '18',
				'max'    => '30',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h3', array(
			'type'                => 'option',
			'default'            => '20',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h3', array(
			'label'            => __( '見出し3の文字サイズ', 'lab23' ),
			'description'    => __( '16〜28pxの範囲で指定できます。（デフォルト:20px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h3',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '16',
				'max'    => '28',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h3_sp', array(
			'type'                => 'option',
			'default'            => '20',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h3_sp', array(
			'label' 		=> __( '見出し3の文字サイズ（スマホ）', 'lab23' ),
			'description'	=> __( '16〜28pxの範囲で指定できます。（デフォルト:20px）', 'lab23' ),
			'section'		=> 'lab23_section_font_size',
			'settings'		=> 'lab23_font_size_h3_sp',
			'type'			=> 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '16',
				'max'    => '28',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h4', array(
			'type'                => 'option',
			'default'            => '18',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h4', array(
			'label'            => __( '見出し4の文字サイズ', 'lab23' ),
			'description'    => __( '14〜26pxの範囲で指定できます。（デフォルト:18px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h4',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '14',
				'max'    => '26',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h4_sp', array(
			'type'                => 'option',
			'default'            => '18',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h4_sp', array(
			'label'            => __( '見出し4の文字サイズ（スマホ）', 'lab23' ),
			'description'    => __( '14〜26pxの範囲で指定できます。（デフォルト:18px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h4_sp',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '14',
				'max'    => '26',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h5', array(
			'type'                => 'option',
			'default'            => '16',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h5', array(
			'label'            => __( '見出し5の文字サイズ', 'lab23' ),
			'description'    => __( '13〜24pxの範囲で指定できます。（デフォルト:16px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h5',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '13',
				'max'    => '24',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h5_sp', array(
			'type'                => 'option',
			'default'            => '16',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h5_sp', array(
			'label'            => __( '見出し5の文字サイズ（スマホ）', 'lab23' ),
			'description'    => __( '13〜24pxの範囲で指定できます。（デフォルト:16px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h5_sp',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '13',
				'max'    => '24',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h6', array(
			'type'                => 'option',
			'default'            => '15',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h6', array(
			'label'            => __( '見出し6の文字サイズ', 'lab23' ),
			'description'    => __( '12〜22pxの範囲で指定できます。（デフォルト:15px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h6',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '12',
				'max'    => '22',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_h6_sp', array(
			'type'                => 'option',
			'default'            => '15',
			'sanitize_callback'    => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_h6_sp', array(
			'label'            => __( '見出し6の文字サイズ（スマホ）', 'lab23' ),
			'description'    => __( '12〜22pxの範囲で指定できます。（デフォルト:15px）', 'lab23' ),
			'section'        => 'lab23_section_font_size',
			'settings'        => 'lab23_font_size_h6_sp',
			'type'            => 'number',
			'input_attrs'    => array(
				'step'    => '1',
				'min'    => '12',
				'max'    => '22',
			),
		) );
		$wp_customize->add_section( 'lab23_mokuji_section', array(
			'title'			=> '目次設定',
			'panel'			=> 'lab23_postpage_panel',
			'description'	=> __( '記事内に表示させる目次の設定。', 'lab23' ),
		) );

		$wp_customize->add_setting( 'lab23_mokuji_auto', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_mokuji_auto', array(
			'section'		=> 'lab23_mokuji_section',
			'settings'		=> 'lab23_mokuji_auto',
			'label'			=> __( '目次を自動表示', 'lab23' ),
			'description'	=> __( '投稿ページに自動で目次を表示。<br>[mokuji]ショートコードがあればその位置に。なければ一番最初の見出しの上に自動表示。<br>個別記事で表示・非表示を切り替えることもできます。', 'lab23' ),
			'type'			=> 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_mokuji_post_type', array(
			'sanitize_callback' => 'lab23_no_sanitize',
			'type'              => 'option',
		) );
		$wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_mokuji_post_type', array(
			'section' => 'lab23_mokuji_section',
			'label'   => __('自動挿入する投稿タイプ', 'lab23' ),
		)) );
		//
		$wp_customize->add_setting( 'lab23_mokuji_auto_post', array(
			'type'				=> 'option',
			'default'			=> true,
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_mokuji_auto_post', array(
			'section'	=> 'lab23_mokuji_section',
			'settings'	=> 'lab23_mokuji_auto_post',
			'label'		=> __( '投稿ページ', 'lab23' ),
			'type'		=> 'checkbox',
		) );
		//
		$wp_customize->add_setting( 'lab23_mokuji_auto_page', array(
			'type'				=> 'option',
			'default'			=> true,
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_mokuji_auto_page', array(
			'section'	=> 'lab23_mokuji_section',
			'settings'	=> 'lab23_mokuji_auto_page',
			'label'		=> __( '固定ページ', 'lab23' ),
			'type'		=> 'checkbox',
		) );

		// 
		$wp_customize->add_setting( 'lab23_mokuji_design', array(
			'type'				=> 'option',
			'default'			=> 'bg-color',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_mokuji_design', array(
			'label'		=> __( '目次のデザイン', 'lab23' ),
			'description'	=> __( '「カスタマイズ」→「色」で設定したカラーを使用します。', 'lab23' ),
			'section'	=> 'lab23_mokuji_section',
			'settings'	=> 'lab23_mokuji_design',
			'type'			=> 'select',
			'choices'		=> array(
				'bg-color'						=> __( '背景に薄いカラー', 'lab23' ),
				'border-color'					=> __( '枠線（ボーダーカラー）', 'lab23' ),
				'border-main-color'				=> __( '枠線（メインカラー）', 'lab23' ),
				'bg-color-border-main-color'	=> __( '背景色 + 枠線（メインカラー）', 'lab23' ),
				'border-text-color'				=> __( '枠線（テキストカラー）', 'lab23' ),
				'bg-color-border-text-color'	=> __( '背景色 + 枠線（テキストカラー）', 'lab23' ),
			),
		) );
		
		$wp_customize->add_setting( 'lab23_mokuji_detail_setting', array(
			'sanitize_callback' => 'lab23_no_sanitize',
			'type'              => 'option',
		) );
		$wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_mokuji_detail_setting', array(
			'section' => 'lab23_mokuji_section',
			'label'   => __( '詳細設定', 'lab23' ),
		)) );

		$wp_customize->add_setting( 'lab23_mokuji_numbering', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_mokuji_numbering', array(
			'section'	=> 'lab23_mokuji_section',
			'settings'	=> 'lab23_mokuji_numbering',
			'label'		=> '目次に番号を振る',
			'type'		=> 'checkbox',
		) );

		$wp_customize->add_setting( 'lab23_mokuji_number', array(
			'default'			=> '1',
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_mokuji_number', array(
			'section'		=> 'lab23_mokuji_section',
			'settings'		=> 'lab23_mokuji_number',
			'description'	=> '目次を表示するための最小見出し数を指定',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step' => '1',
				'min'  => '1',
				'max'  => '20',
			),
		) );
		// 表示する見出しの深さ
		$wp_customize->add_setting( 'lab23_mokuji_heading_num', array(
			'default'			=> '3',
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_mokuji_heading_num', array(
			'section'		=> 'lab23_mokuji_section',
			'settings'		=> 'lab23_mokuji_heading_num',
			'description'	=> 'どの見出しまで目次に含めるか',
			'type'			=> 'select',
			'choices'		=> array(
				'2' => 'h2まで',
				'3' => 'h3まで',
				'4' => 'h4まで',
				'5' => 'h5まで',
				'6' => 'h6まで',
			),
		) );
		// 目次パネルデフォルト設定
		$wp_customize->add_setting( 'lab23_mokuji_close', array( 
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_mokuji_close', array( 
			'section'	=> 'lab23_mokuji_section', 
			'settings'	=> 'lab23_mokuji_close', 
			'label'		=> '目次をデフォルトで閉じておく',
			'type'      => 'checkbox',
		) );

		//
		$wp_customize->add_setting( 'lab23_mokuji_title', array(
			'type'				=> 'option',
			'default'			=> __( '目次', 'lab23' ),
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_mokuji_title', array(
			'label'			=> __( '目次のタイトル', 'lab23' ),
			'section'		=> 'lab23_mokuji_section',
			'settings'		=> 'lab23_mokuji_title',
			'type'			=> 'text',
		) );

		//
		$wp_customize->add_setting( 'lab23_mokuji_open_text', array(
			'type'				=> 'option',
			'default'			=> __( 'open', 'lab23' ),
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_mokuji_open_text', array(
			'label'			=> __( '開くボタンの表記', 'lab23' ),
			'section'		=> 'lab23_mokuji_section',
			'settings'		=> 'lab23_mokuji_open_text',
			'type'			=> 'text',
		) );
		//
		$wp_customize->add_setting( 'lab23_mokuji_close_text', array(
			'type'				=> 'option',
			'default'			=> __( 'close', 'lab23' ),
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_mokuji_close_text', array(
			'label'			=> __( '閉じるボタンの表記', 'lab23' ),
			'section'		=> 'lab23_mokuji_section',
			'settings'		=> 'lab23_mokuji_close_text',
			'type'			=> 'text',
		) );

		/**
		 * 見出しのデザイン
		 */
		$heading_styles = array(
			'type0' => __( '太字のみ', 'lab23' ),
			'type1' => __( '背景メインカラー', 'lab23' ),
			'type2' => __( '背景薄い色', 'lab23' ),
			'type3' => __( '背景メインカラー（角丸）', 'lab23' ),
			'type4' => __( '背景薄い色（角丸）', 'lab23' ),
			'type5' => __( '背景メインカラー（吹き出し）', 'lab23' ),
			'type6' => __( '背景薄い色（吹き出し）', 'lab23' ),
			'type7' => __( '左ライン + 背景薄い色', 'lab23' ),
			'type8' => __( '左ライン', 'lab23' ),
			'type9' => __( '左ライン（細）', 'lab23' ),
			'type10' => __( 'ボーダー', 'lab23' ),
		);
		$wp_customize->add_section( 'lab23_section_heading_style', array(
			'title'			=> __( '見出しのデザイン', 'lab23' ),
			'panel'			=> 'lab23_postpage_panel',
			'description'	=> __( '見出しのデザインを設定します', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_heading_h2_style', array(
			'type'				=> 'option',
			'default'			=> 'type0',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_heading_h2_style', array(
			'label'		=> __( '記事内h2見出しのスタイル', 'lab23' ),
			'section'	=> 'lab23_section_heading_style',
			'settings'	=> 'lab23_heading_h2_style',
			'type'		=> 'select',
			'choices'	=> $heading_styles,
		) );
		$wp_customize->add_setting( 'lab23_heading_h3_style', array(
			'type'				=> 'option',
			'default'			=> 'type0',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_heading_h3_style', array(
			'label'		=> __( '記事内h3見出しのスタイル', 'lab23' ),
			'section'	=> 'lab23_section_heading_style',
			'settings'	=> 'lab23_heading_h3_style',
			'type'		=> 'select',
			'choices'	=> $heading_styles,
		) );
		$wp_customize->add_setting( 'lab23_heading_h4_style', array(
			'type'				=> 'option',
			'default'			=> 'type0',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_heading_h4_style', array(
			'label'		=> __( '記事内h4見出しのスタイル', 'lab23' ),
			'section'	=> 'lab23_section_heading_style',
			'settings'	=> 'lab23_heading_h4_style',
			'type'		=> 'select',
			'choices'	=> $heading_styles,
		) );
		$wp_customize->add_setting( 'lab23_heading_h5_style', array(
			'type'				=> 'option',
			'default'			=> 'type0',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_heading_h5_style', array(
			'label'		=> __( '記事内h5見出しのスタイル', 'lab23' ),
			'section'	=> 'lab23_section_heading_style',
			'settings'	=> 'lab23_heading_h5_style',
			'type'		=> 'select',
			'choices'	=> $heading_styles,
		) );
		$wp_customize->add_setting( 'lab23_heading_h6_style', array(
			'type'				=> 'option',
			'default'			=> 'type0',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_heading_h6_style', array(
			'label'		=> __( '記事内h6見出しのスタイル', 'lab23' ),
			'section'	=> 'lab23_section_heading_style',
			'settings'	=> 'lab23_heading_h6_style',
			'type'		=> 'select',
			'choices'	=> $heading_styles,
		) );
		
		/**
		 * Advertisement tag
		 */
		$wp_customize->add_section( 'lab23_section_ad_tag', array(
			'title'			=> __( '広告表記', 'lab23' ),
			'panel'			=> 'lab23_postpage_panel',
			'description'	=> __( 'タイトル下に広告表記を表示する', 'lab23' ),
		) );
		// Advertisement text
		$wp_customize->add_setting( 'lab23_ad_text', array(
			'type'				=> 'option',
			'default'			=> __( '広告', 'lab23' ),
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_ad_text', array(
			'label'			=> __( '広告表記のテキスト', 'lab23' ),
			'section'		=> 'lab23_section_ad_tag',
			'settings'		=> 'lab23_ad_text',
			'type'			=> 'text',
		) );
		// Display tag default
		$wp_customize->add_setting( 'lab23_ad_tag_display_post', array(
			'type'				=> 'option',
			'default'			=> 'hide',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_ad_tag_display_post', array(
			'label'		=> __( 'デフォルトで表示するか（投稿ページ）', 'lab23' ),
			'section'	=> 'lab23_section_ad_tag',
			'settings'	=> 'lab23_ad_tag_display_post',
			'type'		=> 'radio',
			'choices'	=> array(
				'hide' => __( '表示しない', 'lab23' ),
				'show' => __( '表示する', 'lab23' ),
			),
		) );
		// Display tag default
		$wp_customize->add_setting( 'lab23_ad_tag_display_page', array(
			'type'				=> 'option',
			'default'			=> 'hide',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_ad_tag_display_page', array(
			'label'		=> __( 'デフォルトで表示するか（固定ページ）', 'lab23' ),
			'section'	=> 'lab23_section_ad_tag',
			'settings'	=> 'lab23_ad_tag_display_page',
			'type'		=> 'radio',
			'choices'	=> array(
				'hide' => __( '表示しない', 'lab23' ),
				'show' => __( '表示する', 'lab23' ),
			),
		) );
		// Advertisement tag text color
		$wp_customize->add_setting( 'lab23_ad_tag_text_color', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'lab23_ad_tag_text_color', array(
			'label'		=> __( '広告表記の文字色', 'lab23' ),
			'section'	=> 'lab23_section_ad_tag',
			'settings'	=> 'lab23_ad_tag_text_color',
		)) );

		// Advertisement tag background color
		$wp_customize->add_setting( 'lab23_ad_tag_bg_color', array(
			'type'				=> 'option',
			'default'			=> '#eee',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control($wp_customize, 'lab23_ad_tag_bg_color', array(
			'label'			=> __( '広告表記の背景色', 'lab23' ),
			'section'		=> 'lab23_section_ad_tag',
			'settings'		=> 'lab23_ad_tag_bg_color',
		) ) );

		/**
		 * Share button settings
		 */
		$wp_customize->add_section( 'lab23_section_share_btn', array(
			'title'			=> __( 'シェアボタン', 'lab23' ),
			'panel'			=> 'lab23_postpage_panel',
			'description'	=> __( 'シェアボタンの設定ができます。', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_share_btn_style', array(
			'default'			=> 'wide',
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_share_btn_style', array(
			'section'	=> 'lab23_section_share_btn',
			'settings'	=> 'lab23_share_btn_style',
			'label'		=> __( 'シェアボタンのスタイル', 'lab23' ),
			'type'		=> 'select',
			'choices'	=> array(
				'wide'		=> __( 'ワイド', 'lab23' ),
				'3d'		=> __( '3D', 'lab23' ),
				'small'		=> __( 'スモール', 'lab23' ),
				'circle'	=> __( '円形', 'lab23' ),
			),
		) );
		$wp_customize->add_setting( 'lab23_share_btn_position', array(
			'sanitize_callback' => 'lab23_no_sanitize',
			'type'              => 'option',
		) );
		$wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_share_btn_position', array(
			'section' => 'lab23_section_share_btn',
			'label'   => __('シェアボタンの表示', 'lab23' ),
		)) );
		
		// 記事上
		$wp_customize->add_setting( 'lab23_share_btn_entry_top', array(
			'sanitize_callback' => 'lab23_sanitize_checkbox',
			'type'              => 'option',
			'default'            => true,
		) );
		$wp_customize->add_control( 'lab23_share_btn_entry_top', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_share_btn_entry_top',
			'label'        => '記事上にシェアボタンを表示',
			'type'        => 'checkbox',
		) );
		$wp_customize->selective_refresh->add_partial('lab23_share_btn_entry_top', array(
			'selector' => '.share-post',
		) );
		// 記事下
		$wp_customize->add_setting( 'lab23_share_btn_entry_bottom', array(
			'sanitize_callback' => 'lab23_sanitize_checkbox',
			'type'              => 'option',
			'default'            => true,
		) );
		$wp_customize->add_control( 'lab23_share_btn_entry_bottom', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_share_btn_entry_bottom',
			'label'        => '記事下にシェアボタンを表示',
			'type'        => 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_display_share_btn_page_title', array(
			'sanitize_callback'    => 'lab23_no_sanitize',
			'type'              => 'option',
		) );
		$wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_display_share_btn_page_title', array(
			'section'    => 'lab23_section_share_btn',
			'label'        => '固定ページでシェアボタンを表示する',
		)) );
		$wp_customize->add_setting( 'lab23_display_share_btn_page', array(
			'type'                => 'option',
			'sanitize_callback'    => 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_display_share_btn_page', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_display_share_btn_page',
			'label'        => '固定ページで表示',
			'type'        => 'checkbox',
		) );

		/**
		 * Share button type
		 */
		$wp_customize->add_setting( 'lab23_share_btn_service', array(
			'sanitize_callback' => 'lab23_no_sanitize',
		) );
		$wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_share_btn_service', array(
			'section' => 'lab23_section_share_btn',
			'label'   => '表示するシェアボタン',
		)) );
		// Facebook
		$wp_customize->add_setting( 'lab23_share_facebook', array(
			'default'            => true,
			'type'              => 'option',
			'sanitize_callback' => 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_share_facebook', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_share_facebook',
			'label'        => 'Facebookのシェアボタンを表示',
			'type'        => 'checkbox',
		) );
		//Twitter
		$wp_customize->add_setting( 'lab23_share_twitter', array(
			'default'            => true,
			'type'              => 'option',
			'sanitize_callback' => 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_share_twitter', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_share_twitter',
			'label'        => 'Twitterのシェアボタンを表示',
			'type'        => 'checkbox',
		) );
		// Pocket
		$wp_customize->add_setting( 'lab23_share_pocket', array(
			'default'            => true,
			'type'              => 'option',
			'sanitize_callback' => 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_share_pocket', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_share_pocket',
			'label'        => 'Pocketのシェアボタンを表示',
			'type'        => 'checkbox',
		) );
		// LINE
		$wp_customize->add_setting( 'lab23_share_line', array(
			'default'            => true,
			'type'              => 'option',
			'sanitize_callback' => 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_share_line', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_share_line',
			'label'        => 'LINEのシェアボタンを表示',
			'type'        => 'checkbox',
		) );
		// Pinterest
		$wp_customize->add_setting( 'lab23_share_pinterest', array(
			'default'            => true,
			'type'              => 'option',
			'sanitize_callback' => 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_share_pinterest', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_share_pinterest',
			'label'        => 'Pinterestのシェアボタンを表示',
			'type'        => 'checkbox',
		) );
		// Hatena bookmark
		$wp_customize->add_setting( 'lab23_share_hatebu', array(
			'default'            => true,
			'type'              => 'option',
			'sanitize_callback' => 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_share_hatebu', array(
			'section'    => 'lab23_section_share_btn',
			'settings'    => 'lab23_share_hatebu',
			'label'        => 'はてなブックマークのシェアボタンを表示',
			'type'        => 'checkbox',
		) );

		/**
		 * Author data
		 */
		$wp_customize->add_section( 'lab23_section_post_author', array(
			'title'			=> __( '投稿者情報の設定', 'lab23' ),
			'panel'			=> 'lab23_postpage_panel',
			'description'	=> __( '投稿者情報に関する設定', 'lab23' )
		) );

		$wp_customize->add_setting( 'lab23_display_author_info', array(
			'type' => 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_display_author_info', array(
			'label'			=> __( '投稿者情報を表示する', 'lab23' ),
			'description'	=> __('「ユーザー」の各ユーザーページにて入力した情報を記事下に表示させます。', 'lab23' ),
			'section'		=> 'lab23_section_post_author',
			'settings'		=> 'lab23_display_author_info',
			'type'			=> 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_display_author_page_link', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_display_author_page_link', array(
			'label'		=> __( '投稿者記事一覧ページへのリンクを表示する', 'lab23' ),
			'section'	=> 'lab23_section_post_author',
			'settings'	=> 'lab23_display_author_page_link',
			'type'		=> 'checkbox',
		) );

		/**
		 * Related post
		 */
		$wp_customize->add_section( 'lab23_section_related_post', array(
			'title'			=> __( '関連記事設定', 'lab23' ),
			'panel'			=> 'lab23_postpage_panel',
			'description'	=> __( '記事下に表示される関連記事の設定', 'lab23' )
		) );
		// 関連記事を表示する
		$wp_customize->add_setting( 'lab23_display_related_post', array(
			'type' => 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_display_related_post', array(
			'label'			=> __( '関連記事を表示する', 'lab23' ),
			'description'	=> __( '同じカテゴリーの記事がランダムで表示されます。', 'lab23' ),
			'section'		=> 'lab23_section_related_post',
			'settings'		=> 'lab23_display_related_post',
			'type'			=> 'checkbox',
		) );
		// 表示する関連記事の上限
		$wp_customize->add_setting( 'lab23_related_post_length', array(
			'type'				=> 'option',
			'default'			=> '5',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_related_post_length', array(
			'label'			=> __( '表示する記事数の上限', 'lab23' ),
			'description'	=> __( 'デフォルト: 5件', 'lab23' ),
			'section'		=> 'lab23_section_related_post',
			'settings'		=> 'lab23_related_post_length',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '1',
				'max'	=> '20',
			),
		) );
		$wp_customize->add_setting( 'lab23_related_post_heading', array(
			'type'				=> 'option',
			'default'			=> __( '関連記事', 'lab23' ),
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_related_post_heading', array(
			'label'		=> __( '関連記事上の見出し', 'lab23' ),
			'section'	=> 'lab23_section_related_post',
			'settings'	=> 'lab23_related_post_heading',
			'type'		=> 'text',
		) );
	}
	add_action('customize_register', 'lab23_customizer_register_post');
}
