<?php

if (!defined('ABSPATH')) {
	exit;
}

if (!function_exists('lab23_customizer_register_common')) {
	function lab23_customizer_register_common($wp_customize)
	{
		/**
		 * パネルの追加 =========================================================
		 */
		$wp_customize->add_panel('lab23_common_panel', array(
			'title'    => __( '[Lab23]共通設定', 'lab23' ),
			'priority' => 100,
		) );

		/**
		 * 全体デザイン設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_global_design', array(
			'title'	=> __( '全体デザイン設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );

		// Desgin type
		$wp_customize->add_setting( 'lab23_global_design_type', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> 'normal',
		) );
		$wp_customize->add_control( 'lab23_global_design_type', array(
			'label'		=> __( 'デザインタイプ', 'lab23' ),
			'section'	=> 'lab23_section_global_design',
			'settings'	=> 'lab23_global_design_type',
			'type'		=> 'select',
			'choices'	=> array(
				'normal'		=> __( 'ノーマル', 'lab23' ),
				'normal-float'	=> __( 'ノーマル（シャドウあり）', 'lab23' ),
				'card'			=> __( 'カード', 'lab23' ),
				'card-float'	=> __( 'カード（シャドウあり）', 'lab23' ),
				'flat'			=> __( 'フラット', 'lab23' ),
			),
		) );

		/**
		 * フォント設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_font', array(
			'title'	=> __( 'フォント設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );

		// Font family
		$wp_customize->add_setting( 'lab23_font_family', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> 'hiragino',
		) );
		$wp_customize->add_control( 'lab23_font_family', array(
			'label'		=> __( 'フォント', 'lab23' ),
			'section'	=> 'lab23_section_font',
			'settings'	=> 'lab23_font_family',
			'type'		=> 'select',
			'choices'	=> array(
				'hiragino'		=> __( 'ヒラギノ角ゴ（メイリオ）', 'lab23' ),
				'yu-gothic'		=> __( '游ゴシック', 'lab23' ),
				'yu-mincho'		=> __( '游明朝', 'lab23' ),
				'noto-sans-jp'	=> __( 'Noto Sans JP', 'lab23' ),
				'noto-serif-jp'	=> __( 'Noto Serif JP', 'lab23' ),
				'm-plus'		=> __( 'M PLUS 1p', 'lab23' ),
				'm-plus-rounded'=> __( 'M PLUS Rounded 1c', 'lab23' ),
				'zen-old-mincho'=> __( 'Zen Old Mincho', 'lab23' ),
				'zen-maru-gothic'=> __( 'Zen Maru Gothic', 'lab23' ),
				'zen-kurenaido'	=> __( 'Zen Kurenaido', 'lab23' ),
				'kaisei-opti'	=> __( 'Kaisei Opti', 'lab23' ),
				'yuji-syuku'	=> __( 'Yuji Syuku', 'lab23' ),
				'klee-one'		=> __( 'Klee One', 'lab23' ),
				'yomogi'		=> __( 'Yomogi', 'lab23' ),
				'hachi-maru-pop'=> __( 'Hachi Maru Pop', 'lab23' ),
			),
		) );

		/**
		 * ヘッダー設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_header', array(
			'title'	=> __( 'ヘッダー設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );
		// Header style
		$wp_customize->add_setting( 'lab23_header_style', array(
			'type' => 'option',
			'default' => 'type1',
			'sanitize_callback' => 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_header_style', array(
			'label'		=> __( 'ヘッダーデザイン', 'lab23' ),
			'section'	=> 'lab23_section_header',
			'settings'	=> 'lab23_header_style',
			'type'		=> 'select',
			'choices'	=> array(
				'type1'	=> __( 'タイプ1', 'lab23' ),
				'type2'	=> __( 'タイプ2', 'lab23' ),
				'type3'	=> __( 'タイプ3', 'lab23' ),
			),
		) );
		// Header padding
		$wp_customize->add_setting( 'lab23_header_padding', array(
			'type' => 'option',
			'default' => '16',
			'sanitize_callback' => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_header_padding', array(
			'label'       => __( 'ヘッダーの上下余白', 'lab23' ),
			'section'     => 'lab23_section_header',
			'settings'    => 'lab23_header_padding',
			'type'        => 'number',
			'input_attrs' => array(
				'step' => '1',
				'min'  => '0',
				'max' => '50'
			),
		) );
		$wp_customize->add_setting( 'lab23_header_padding_sp', array(
			'type' => 'option',
			'default' => '14',
			'sanitize_callback' => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_header_padding_sp', array(
			'label'       => __( 'ヘッダーの上下余白（スマホ）', 'lab23' ),
			'section'     => 'lab23_section_header',
			'settings'    => 'lab23_header_padding_sp',
			'type'        => 'number',
			'input_attrs' => array(
				'step' => '1',
				'min'  => '0',
				'max' => '50'
			),
		) );

		// Header logo
		$wp_customize->add_setting( 'lab23_logo_image', array(
			'sanitize_callback' => 'lab23_slug_sanitize_image',
		) );
		$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'lab23_logo_image', array(
			'label'		=> __( 'ヘッダー左上のサイトロゴ画像', 'lab23' ),
			'section'	=> 'lab23_section_header',
			'settings'	=> 'lab23_logo_image',
		)) );
		$wp_customize->selective_refresh->add_partial('lab23_logo_image', array(
			'selector' => '#logo',
		) );
		// Logo height
		$wp_customize->add_setting( 'lab23_logo_image_height', array(
			'type' => 'option',
			'default' => '36',
			'sanitize_callback' => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_logo_image_height', array(
			'label'       => __( 'ロゴ画像の高さ', 'lab23' ),
			'description' => __( '20~50pxの範囲で設定できます。', 'lab23' ),
			'section'     => 'lab23_section_header',
			'settings'    => 'lab23_logo_image_height',
			'type'        => 'number',
			'input_attrs' => array(
				'step'	=> '1',
				'min'	=> '20',
				'max'	=> '50'
			),
		) );
		// Heading
		$wp_customize->add_setting( 'lab23_header_shadow_title', array(
            'sanitize_callback' => 'lab23_no_sanitize',
            'type'              => 'option',
        ) );
        $wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_header_shadow_title', array(
            'section' => 'lab23_section_header',
            'label'   => 'シャドウ設定',
        )) );
		// Header Shadow
		$wp_customize->add_setting( 'lab23_header_shadow', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_header_shadow', array(
			'label'		=> 'ヘッダーにシャドウを入れる',
			'section'	=> 'lab23_section_header',
			'settings'	=> 'lab23_header_shadow',
			'type'		=> 'checkbox',
		) );
		// Heading
		$wp_customize->add_setting( 'lab23_header_fixed_title', array(
            'sanitize_callback' => 'lab23_no_sanitize',
            'type'              => 'option',
        ) );
		$wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_header_fixed_title', array(
            'section' => 'lab23_section_header',
            'label'   => '配置設定',
        )) );
		// Fixed Header
		$wp_customize->add_setting( 'lab23_header_fixed', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_header_fixed', array(
			'label'		=> 'ヘッダーをスクロールに追従させる',
			'section'	=> 'lab23_section_header',
			'settings'	=> 'lab23_header_fixed',
			'type'		=> 'checkbox',
		) );
		// Heading
		$wp_customize->add_setting( 'lab23_nav_font_weight_title', array(
            'sanitize_callback' => 'lab23_no_sanitize',
            'type'              => 'option',
        ) );
        $wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_nav_font_weight_title', array(
            'section' => 'lab23_section_header',
            'label'   => __( 'グローバルナビのテキスト設定', 'lab23' ),
        )) );
		// Global nav font weight
		$wp_customize->add_setting( 'lab23_nav_weight_bold', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_nav_weight_bold', array(
			'label'		=> __( 'グローバルナビを太字にする', 'lab23' ),
			'section'	=> 'lab23_section_header',
			'settings'	=> 'lab23_nav_weight_bold',
			'type'		=> 'checkbox',
		) );
		// Heading
		$wp_customize->add_setting( 'lab23_display_search_btn_title', array(
            'sanitize_callback' => 'lab23_no_sanitize',
            'type'              => 'option',
        ) );
        $wp_customize->add_control(new Lab23_Custom_Title($wp_customize, 'lab23_display_search_btn_title', array(
            'section' => 'lab23_section_header',
            'label'   => __( 'ヘッダー検索ボタン', 'lab23' ),
        )) );
		// Search Button
		$wp_customize->add_setting( 'lab23_display_search_btn', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_display_search_btn', array(
			'label'		=> __( 'ヘッダーに検索ボタンを設置する', 'lab23' ),
			'section'	=> 'lab23_section_header',
			'settings'	=> 'lab23_display_search_btn',
			'type'		=> 'checkbox',
		) );

		/**
		 * ヘッダーボタン設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_header_btn', array(
			'title'	=> __( 'ヘッダーボタン設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );
		$wp_customize->add_setting( 'lab23_header_btn_url', array(
			'type'				=> 'option',
			'sanitize_callback' => 'esc_url',
		) );
		$wp_customize->add_control( 'lab23_header_btn_url', array(
			'label'		=> __( 'ボタンのリンク先URL', 'lab23' ),
			'section'	=> 'lab23_section_header_btn',
			'settings'	=> 'lab23_header_btn_url',
			'type'		=> 'text',
		) );
		$wp_customize->add_setting( 'lab23_hide_header_btn_sp', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_hide_header_btn_sp', array(
			'label'		=> __( 'スマホでボタンを非表示にする', 'lab23' ),
			'section'	=> 'lab23_section_header_btn',
			'settings'	=> 'lab23_hide_header_btn_sp',
			'type'		=> 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_header_btn_text', array(
			'type'				=> 'option',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_header_btn_text', array(
			'label'		=> __( 'ボタンのテキスト', 'lab23' ),
			'section'	=> 'lab23_section_header_btn',
			'settings'	=> 'lab23_header_btn_text',
			'type'		=> 'text',
		) );
		$wp_customize->add_setting( 'lab23_header_btn_color', array(
			'type'				=> 'option',
			'default'			=> '#d31111',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_header_btn_color', array(
			'label'		=> __( 'ボタン背景色', 'lab23' ),
			'section'	=> 'lab23_section_header_btn',
			'settings'	=> 'lab23_header_btn_color',
		) ) );
		$wp_customize->add_setting( 'lab23_header_btn_text_color', array(
			'type'				=> 'option',
			'default'			=> '#fff',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_header_btn_text_color', array(
			'label'		=> __( 'ボタンテキストカラー', 'lab23' ),
			'section'	=> 'lab23_section_header_btn',
			'settings'	=> 'lab23_header_btn_text_color',
		) ) );
		$wp_customize->add_setting( 'lab23_header_btn_icon', array(
			'type' => 'option',
			'default' => 'none',
			'sanitize_callback' => 'lab23_sanitize_select',
		) );
		$wp_customize->add_control( 'lab23_header_btn_icon', array(
			'label'       => __( 'ボタンのアイコン', 'lab23' ),
			'section'     => 'lab23_section_header_btn',
			'settings'    => 'lab23_header_btn_icon',
			'type'			=> 'select',
			'choices'	=> array(
				'none'			=> __( 'アイコンなし', 'lab23' ),
				'mail'			=> __( 'メールアイコン1', 'lab23' ),
				'mail-solid'	=> __( 'メールアイコン2', 'lab23' ),
				'tel'			=> __( 'TELアイコン1', 'lab23' ),
				'tel-solid'		=> __( 'TELアイコン2', 'lab23' ),
			),
		) );
		$wp_customize->add_setting( 'lab23_header_btn_border_radius', array(
			'type' => 'option',
			'default' => '6',
			'sanitize_callback' => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_header_btn_border_radius', array(
			'label'       => __( 'ボタンの角丸', 'lab23' ),
			'section'     => 'lab23_section_header_btn',
			'settings'    => 'lab23_header_btn_border_radius',
			'type'        => 'number',
			'input_attrs' => array(
				'step' => '1',
				'min'  => '0',
				'max' => '200'
			),
		) );

		/**
		 * お知らせ =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_header_info', array(
			'title'			=> __( 'お知らせ設定', 'lab23' ),
			'description'	=> __( 'ヘッダー下にお知らせを表示できます。<br>テンプレートが「トップページ用」の場合は表示されません。', 'lab23' ),
			'panel'			=> 'lab23_common_panel',
		) );
		$wp_customize->add_setting( 'lab23_header_info_url', array(
			'type'				=> 'option',
			'sanitize_callback' => 'esc_url',
		) );
		$wp_customize->add_control( 'lab23_header_info_url', array(
			'label'			=> __( 'お知らせのリンク先URL', 'lab23' ),
			'section'		=> 'lab23_section_header_info',
			'settings'		=> 'lab23_header_info_url',
			'type'			=> 'text',
		) );
		$wp_customize->add_setting( 'lab23_header_info_text', array(
			'type'				=> 'option',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_header_info_text', array(
			'label'			=> __( 'お知らせのテキスト', 'lab23' ),
			'section'		=> 'lab23_section_header_info',
			'settings'		=> 'lab23_header_info_text',
			'type'			=> 'textarea',
		) );
		$wp_customize->add_setting( 'lab23_header_info_bg_color', array(
			'type'                => 'option',
			'default'            => '#333',
			'sanitize_callback'    => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'lab23_header_info_bg_color', array(
			'label'        => __( 'お知らせの背景色', 'lab23' ),
			'section'    => 'lab23_section_header_info',
			'settings'    => 'lab23_header_info_bg_color',
		)) );
		$wp_customize->add_setting( 'lab23_header_info_text_color', array(
			'type'                => 'option',
			'default'            => '#fff',
			'sanitize_callback'    => 'sanitize_hex_color',
		) );
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'lab23_header_info_text_color', array(
			'label'        => __( 'お知らせの文字色', 'lab23' ),
			'section'    => 'lab23_section_header_info',
			'settings'    => 'lab23_header_info_text_color',
		)) );

		/**
		 * 投稿一覧設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_archive', array(
			'title'	=> __( '投稿一覧設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );

		// 投稿一覧のデザイン
		$wp_customize->add_setting( 'lab23_archive_design', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> 'card',
		) );
		$wp_customize->add_control( 'lab23_archive_design', array(
			'label'		=> __( '投稿一覧のデザイン', 'lab23' ),
			'section'	=> 'lab23_section_archive',
			'settings'	=> 'lab23_archive_design',
			'type'		=> 'select',
			'choices'	=> array(
				'card'			=> __( 'カード', 'lab23' ),
				'information'	=> __( 'ニュース', 'lab23' ),
			),
		) );
		$wp_customize->add_setting( 'lab23_archive_title', array(
			'type'				=> 'option',
			'sanitize_callback' => 'sanitize_text_field',
			'default'			=> __( '投稿一覧', 'lab23')
		) );
		$wp_customize->add_control( 'lab23_archive_title', array(
			'label'			=> __( '投稿一覧（ホームページ）のタイトル', 'lab23' ),
			'description'	=> __( '例:「投稿一覧」', 'lab23' ),
			'section'		=> 'lab23_section_archive',
			'settings'		=> 'lab23_archive_title',
			'type'			=> 'text',
		) );
		$wp_customize->add_setting( 'lab23_font_size_archive_title', array(
			'type'				=> 'option',
			'default'			=> '20',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_archive_title', array(
			'label'			=> __( '投稿一覧タイトルの文字サイズ（PC)', 'lab23' ),
			'description'	=> __( '12〜40pxの範囲で指定できます。（デフォルト:20px）', 'lab23' ),
			'section'		=> 'lab23_section_archive',
			'settings'		=> 'lab23_font_size_archive_title',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '12',
				'max'	=> '40',
			),
		) );
		$wp_customize->add_setting( 'lab23_font_size_archive_title_sp', array(
			'type'				=> 'option',
			'default'			=> '18',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_font_size_archive_title_sp', array(
			'label'			=> __( '投稿一覧タイトルの文字サイズ（スマホ)', 'lab23' ),
			'description'	=> __( '12〜30pxの範囲で指定できます。（デフォルト:18px）', 'lab23' ),
			'section'		=> 'lab23_section_archive',
			'settings'		=> 'lab23_font_size_archive_title_sp',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '12',
				'max'	=> '30',
			),
		) );
		// Display excerpt
		$wp_customize->add_setting( 'lab23_display_excerpt_archive', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_display_excerpt_archive', array(
			'label'			=> __( '抜粋を表示する', 'lab23' ),
			'description'	=> __( '投稿一覧に抜粋を表示する', 'lab23' ),
			'section'		=> 'lab23_section_archive',
			'settings'		=> 'lab23_display_excerpt_archive',
			'type'			=> 'checkbox',
		) );
		// Default thumbnail
		$wp_customize->add_setting( 'lab23_default_thumbnail', array(
			'sanitize_callback' => 'lab23_slug_sanitize_image',
			'type'				=> 'option',
		) );
		$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'lab23_default_thumbnail', array(
			'label'			=> __( 'デフォルトのサムネイル画像', 'lab23' ),
			'description'	=> __( '投稿のアイキャッチが設定されていない場合、この画像が表示されます。', 'lab23' ),
			'section'		=> 'lab23_section_archive',
			'settings'		=> 'lab23_default_thumbnail',
		) ) );
		$wp_customize->add_setting( 'lab23_archive_pager', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> 'border',
		) );
		$wp_customize->add_control( 'lab23_archive_pager', array(
			'label'			=> __( 'ページャーのデザイン', 'lab23' ),
			'section'		=> 'lab23_section_archive',
			'settings'		=> 'lab23_archive_pager',
			'type'			=> 'select',
			'choices'	=> array(
				'border'	=> 'ボーダー',
				'circle'	=> '丸',
				'square'	=> '四角',
			),
		) );

		/**
		 * カラム設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_column', array(
			'title'	=> __( 'カラム設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );
		$wp_customize->add_setting( 'lab23_column_post', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> '2columns',
		) );
		$wp_customize->add_control( 'lab23_column_post', array(
			'label'			=> __( '投稿のカラム数', 'lab23' ),
			'section'		=> 'lab23_section_column',
			'settings'		=> 'lab23_column_post',
			'type'			=> 'select',
			'choices'	=> array(
				'1column'		=> '1カラム',
				'2columns'		=> '2カラム',
			),
		) );
		$wp_customize->add_setting( 'lab23_column_page', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> '2columns',
		) );
		$wp_customize->add_control( 'lab23_column_page', array(
			'label'			=> __( '固定ページのカラム数', 'lab23' ),
			'description'	=> __( 'テンプレートを<b>「デフォルトレイアウト」</b>に選択した時のカラム数', 'lab23' ),
			'section'		=> 'lab23_section_column',
			'settings'		=> 'lab23_column_page',
			'type'			=> 'select',
			'choices'		=> array(
				'1column'	=> '1カラム',
				'2columns'	=> '2カラム',
			),
		) );
		$wp_customize->add_setting( 'lab23_column_archive', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> '2columns',
		) );
		$wp_customize->add_control( 'lab23_column_archive', array(
			'label'		=> __( '投稿一覧のカラム数', 'lab23' ),
			'section'	=> 'lab23_section_column',
			'settings'	=> 'lab23_column_archive',
			'type'		=> 'select',
			'choices'	=> array(
				'1column'	=> '1カラム',
				'2columns'	=> '2カラム',
			),
		) );

		/**
		 * コンテンツ幅設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_width', array(
			'title'	=> __( 'コンテンツ最大幅設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );
		$wp_customize->add_setting( 'lab23_contents_max_width_2column', array(
			'type' => 'option',
			'default' => '1080',
			'sanitize_callback' => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_contents_max_width_2column', array(
			'label'       => __( '2カラム時の最大幅', 'lab23' ),
			'description' => __( 'サイドバーを含んだ幅です。', 'lab23' ),
			'section'     => 'lab23_section_width',
			'settings'    => 'lab23_contents_max_width_2column',
			'type'        => 'number',
			'input_attrs' => array(
				'step'	=> '1',
				'min'	=> '800',
				'max'	=> '2000'
			),
		) );
		$wp_customize->add_setting( 'lab23_contents_max_width_1column', array(
			'type'				=> 'option',
			'default'			=> '900',
			'sanitize_callback' => 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_contents_max_width_1column', array(
			'label'       => __( '1カラム時の最大幅', 'lab23' ),
			'section'     => 'lab23_section_width',
			'settings'    => 'lab23_contents_max_width_1column',
			'type'        => 'number',
			'input_attrs' => array(
				'step'	=> '1',
				'min'	=> '400',
				'max'	=> '2000'
			),
		) );

		/**
		 * サイドバー設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_widget', array(
			'title'	=> __( 'ウィジェットデザイン設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );
		$wp_customize->add_setting( 'lab23_mainarea_widget_heading_design', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> 'default',
		) );
		$wp_customize->add_control( 'lab23_mainarea_widget_heading_design', array(
			'label'			=> __( 'メインエリアウィジェットの見出しデザイン', 'lab23' ),
			'description'	=> __( '記事上・記事下ウィジェット、コメント欄の見出しデザイン', 'lab23' ),
			'section'		=> 'lab23_section_widget',
			'settings'		=> 'lab23_mainarea_widget_heading_design',
			'type'			=> 'select',
			'choices'		=> array(
				'default'			=> 'デフォルト',
				'background-color'	=> '背景色',
				'line-left'			=> '左ライン',
			),
		) );
		$wp_customize->add_setting( 'lab23_sidebar_heading_design', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> 'default',
		) );
		$wp_customize->add_control( 'lab23_sidebar_heading_design', array(
			'label'		=> __( 'サイドバーウィジェットの見出しデザイン', 'lab23' ),
			'section'	=> 'lab23_section_widget',
			'settings'	=> 'lab23_sidebar_heading_design',
			'type'		=> 'select',
			'choices'	=> array(
				'default'			=> 'デフォルト',
				'background-color'	=> '背景色',
				'line-left'			=> '左ライン',
			),
		) );

		/**
		 * ページトップボタン設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_page_top_btn', array(
			'title'	=> __( 'ページトップへボタン設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );

		// ページトップボタンを非表示
		$wp_customize->add_setting( 'lab23_hide_page_top_btn', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_hide_page_top_btn', array(
			'label'			=> __( 'ページトップボタンを非表示', 'lab23' ),
			'description'	=> '画面下のページトップに戻るボタンを非表示にする',
			'section'		=> 'lab23_section_page_top_btn',
			'settings'		=> 'lab23_hide_page_top_btn',
			'type'			=> 'checkbox',
		) );

		$wp_customize->add_setting( 'lab23_page_top_btn_type', array(
			'type'				=> 'option',
			'sanitize_callback' => 'lab23_sanitize_select',
			'default'			=> 'circle',
		) );
		$wp_customize->add_control( 'lab23_page_top_btn_type', array(
			'label'		=> __( 'ページトップボタンの形状', 'lab23' ),
			'section'	=> 'lab23_section_page_top_btn',
			'settings'	=> 'lab23_page_top_btn_type',
			'type'		=> 'select',
			'choices'	=> array(
				'circle'	=> '円',
				'square'	=> '四角',
			),
		) );

		/**
		 * フッター設定 =========================================================
		 */
		$wp_customize->add_section( 'lab23_section_footer', array(
			'title'	=> __( 'フッター設定', 'lab23' ),
			'panel'	=> 'lab23_common_panel',
		) );

		// コピーライト
		$wp_customize->add_setting( 'lab23_copyright_year', array(
			'type'				=> 'option',
			'sanitize_callback' => 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_copyright_year', array(
			'label'			=> 'サイト開設年',
			'description'	=> '例:「202X」',
			'section'		=> 'lab23_section_footer',
			'settings'		=> 'lab23_copyright_year',
			'type'			=> 'text',
		) );
		$wp_customize->selective_refresh->add_partial('lab23_copyright_year', array(
			'selector' => '#c-copyright',
		) );

		// 現在の年を表示
		$wp_customize->add_setting( 'lab23_copyright_this_year', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_copyright_this_year', array(
			'label'			=> '現在の年を表示',
			'description'	=> '開設年が今年の場合、翌年から表示されます。',
			'section'		=> 'lab23_section_footer',
			'settings'		=> 'lab23_copyright_this_year',
			'type'			=> 'checkbox',
		) );

		// サイトの著作権者（運営者）
		$wp_customize->add_setting( 'lab23_copyright_author', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_copyright_author', array(
			'label'			=> 'サイトの著作権者（運営者）',
			'description'	=> '未入力の場合はサイト名が表示されます。',
			'section'		=> 'lab23_section_footer',
			'settings'		=> 'lab23_copyright_author',
			'type'			=> 'text',
		) );
	}
	add_action('customize_register', 'lab23_customizer_register_common');
}
