<?php
/**
 * カスタマイザーの設定
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! function_exists( 'lab23_customizer_register_ads' ) ) {
	function lab23_customizer_register_ads( $wp_customize ) {
		/**
		 * アドセンスパネル =========================================================
		 */
		$wp_customize->add_panel( 'lab23_adsense_panel', array(
			'title'		=> '[Lab23]アドセンスの設定',
			'priority'	=> 100,
		));
		/**
		 * 記事中自動
		 */
		$wp_customize->add_section( 'lab23_section_adsense_auto_post', array(
			'title'			=> __( '記事中に自動アドセンス', '' ),
			'panel'			=> 'lab23_adsense_panel',
			'description'	=> __( '記事中の見出しに自動で挿入できるアドセンス<br>記事ごとに表示・非表示の設定もできます。', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_adsense_auto_post_code', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_no_sanitize',
		) );
		$wp_customize->add_control( 'lab23_adsense_auto_post_code', array(
			'label'			=> __( 'アドセンスのコード', 'lab23' ),
			'description'	=> __( '記事中に自動で挿入したいアドセンスのコードをコピペしてください。', 'lab23' ),
			'section'		=> 'lab23_section_adsense_auto_post',
			'settings'		=> 'lab23_adsense_auto_post_code',
			'type'			=> 'textarea',
		) );
		$wp_customize->add_setting( 'lab23_adsense_auto_post_type', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_adsense_auto_post_type', array(
			'settings'		=> 'lab23_adsense_auto_post_type',
			'section'		=> 'lab23_section_adsense_auto_post',
			'label'			=> __( '固定ページでも自動挿入する', 'lab23' ),
			'type'			=> 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_adsense_auto_post_first', array(
			'type'				=> 'option',
			'default'			=> '1',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_adsense_auto_post_first', array(
			'label'			=> __( '最初に表示させる見出しの位置', 'lab23' ),
			'description'	=> __( '○番目の見出しの上にアドセンス', 'lab23' ),
			'section'		=> 'lab23_section_adsense_auto_post',
			'settings'		=> 'lab23_adsense_auto_post_first',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '1',
				'max'	=> '10',
			),
		) );
		$wp_customize->add_setting( 'lab23_adsense_auto_post_pos', array(
			'type'				=> 'option',
			'default'			=> '5',
			'sanitize_callback'	=> 'lab23_sanitize_number_range',
		) );
		$wp_customize->add_control( 'lab23_adsense_auto_post_pos', array(
			'label'			=> __( '表示させる頻度', 'lab23' ),
			'description'	=> __( '見出し○個ごとにアドセンスが挿入されます。', 'lab23' ),
			'section'		=> 'lab23_section_adsense_auto_post',
			'settings'		=> 'lab23_adsense_auto_post_pos',
			'type'			=> 'number',
			'input_attrs'	=> array(
				'step'	=> '1',
				'min'	=> '1',
				'max'	=> '10',
			),
		) );
		$wp_customize->add_setting( 'lab23_adsense_auto_post_include_heading_title', array(
			'sanitize_callback'	=> 'lab23_no_sanitize',
		) );
		$wp_customize->add_control( new Lab23_Custom_Title( $wp_customize, 'lab23_adsense_auto_post_include_heading_title', array(
			'section'	=> 'lab23_section_adsense_auto_post',
			'label'		=> __( 'カウントする見出し', 'lab23' ),
		) ) );
		$wp_customize->add_setting( 'lab23_adsense_include_h2', array(
			'type'				=> 'option',
			'default'			=> 'checked',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_adsense_include_h2', array(
			'label'			=> __( '見出し2', 'lab23' ),
			'section'		=> 'lab23_section_adsense_auto_post',
			'settings'		=> 'lab23_adsense_include_h2',
			'type'			=> 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_adsense_include_h3', array(
			'type'				=> 'option',
			'default'			=> 'checked',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_adsense_include_h3', array(
			'label'			=> __( '見出し3', 'lab23' ),
			'section'		=> 'lab23_section_adsense_auto_post',
			'settings'		=> 'lab23_adsense_include_h3',
			'type'			=> 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_adsense_include_h4', array(
			'type'				=> 'option',
			'default'			=> 'checked',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_adsense_include_h4', array(
			'label'		=> __( '見出し4', 'lab23' ),
			'section'	=> 'lab23_section_adsense_auto_post',
			'settings'	=> 'lab23_adsense_include_h4',
			'type'		=> 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_adsense_include_h5', array(
			'type'				=> 'option',
			'default'			=> 'checked',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_adsense_include_h5', array(
			'label'		=> __( '見出し5', 'lab23' ),
			'section'	=> 'lab23_section_adsense_auto_post',
			'settings'	=> 'lab23_adsense_include_h5',
			'type'		=> 'checkbox',
		) );
		$wp_customize->add_setting( 'lab23_adsense_include_h6', array(
			'type'				=> 'option',
			'default'			=> 'checked',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_adsense_include_h6', array(
			'label'		=> __( '見出し6', 'lab23' ),
			'section'	=> 'lab23_section_adsense_auto_post',
			'settings'	=> 'lab23_adsense_include_h6',
			'type'		=> 'checkbox',
		) );

		/**
		 * ショートコード
		 */
		$wp_customize->add_section( 'lab23_section_adsense_shortcode', array(
			'title'			=> __( 'ショートコードで呼び出せるアドセンスコード', 'lab23' ),
			'panel'			=> 'lab23_adsense_panel',
			'description'	=> __( '[ads]ショートコードで表示させるアドセンス広告', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_adsense_shortcode', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_no_sanitize',
		) );
		$wp_customize->add_control( 'lab23_adsense_shortcode', array(
			'label'			=> __( 'アドセンスのコード', 'lab23' ),
			'description'	=> __( '[ads]ショートコードで呼び出せるアドセンスコードです。', 'lab23' ),
			'section'		=> 'lab23_section_adsense_shortcode',
			'settings'		=> 'lab23_adsense_shortcode',
			'type'			=> 'textarea',
		) );
		/**
		 * 自動広告
		 */
		$wp_customize->add_section( 'lab23_section_adsense_auto', array(
			'title'			=> __( '自動広告コード', 'lab23' ),
			'panel'			=> 'lab23_adsense_panel',
			'description'	=> __( 'アドセンスに関する設定です。', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_adsense_auto', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_no_sanitize',
		) );
		$wp_customize->add_control( 'lab23_adsense_auto', array(
			'label'			=> __( 'アドセンスのコード', 'lab23' ),
			'description'	=> __( '自動広告のコードはこちら<br>審査用のコードもこちらです。', 'lab23' ),
			'section'		=> 'lab23_section_adsense_auto',
			'settings'		=> 'lab23_adsense_auto',
			'type'			=> 'textarea',
		) );
		/**
		 * インフィード広告
		 */
		$wp_customize->add_section( 'lab23_section_adsense_infeed', array(
			'title'			=> __( 'インフィード広告', 'lab23' ),
			'panel'			=> 'lab23_adsense_panel',
			'description'	=> __( '記事一覧に挿入されるアドセンス広告です', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_infeed_adsense_code', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_no_sanitize',
		) );
		$wp_customize->add_control( 'lab23_infeed_adsense_code', array(
			'label'			=> __( 'インフィード広告のタグ', 'lab23' ),
			'description'	=> __( 'インフィード広告のタグをコピペしてください。', 'lab23' ),
			'section'		=> 'lab23_section_adsense_infeed',
			'settings'		=> 'lab23_infeed_adsense_code',
			'type'			=> 'textarea',
		) );
		$wp_customize->add_setting( 'lab23_infeed_adsense_code_num', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_text_field',
		) );
		$wp_customize->add_control( 'lab23_infeed_adsense_code_num', array(
			'label'			=> __( 'インフィード広告挿入位置', 'lab23' ),
			'description'	=> __( '〇個目記事の前にインフィード広告を挿入します。複数設定する場合、コンマ区切りで記述してください。<br>例：1,5', 'lab23' ),
			'section'		=> 'lab23_section_adsense_infeed',
			'settings'		=> 'lab23_infeed_adsense_code_num',
			'type'			=> 'text',
		) );
		/**
		 * アドセンスの遅延読み込み
		 */
		$wp_customize->add_section( 'lab23_section_adsense_lazyload', array(
			'title'			=> __( 'アドセンスの遅延読み込み', 'lab23' ),
			'panel'			=> 'lab23_adsense_panel',
			'description'	=> __( '記事内自動アドセンス、インフィード、ショートコード、アドセンスウィジェット内のアドセンスの読み込みを遅延させます。<br><br>※収益に影響が出る可能性があります。<br>※必ず表示確認をしてください。<br>※自動広告は遅延されません。', 'lab23' ),
		) );
		$wp_customize->add_setting( 'lab23_adsense_available_lazyload', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'lab23_sanitize_checkbox',
		) );
		$wp_customize->add_control( 'lab23_adsense_available_lazyload', array(
			'label'			=> __( 'アドセンス遅延読み込み', 'lab23' ),
			'section'		=> 'lab23_section_adsense_lazyload',
			'settings'		=> 'lab23_adsense_available_lazyload',
			'type'			=> 'checkbox',
		) );
	}
	add_action( 'customize_register', 'lab23_customizer_register_ads' );
}
