<?php
$header_image = get_header_image();
$header_image_sp = lab23_get_the_customizer_image_info( 'lab23_sp_header_image', 'full');
$header_video_settings = get_header_video_settings();
$has_video = isset( $header_video_settings["videoUrl"] ) && ! empty($header_video_settings["videoUrl"])
	? true
	: false;

if ( ! $header_image_sp && ! $header_image && ! $has_video ) return;

$header_text = get_option( 'lab23_header_image_text', '' );
$wrapper_color = get_option( 'lab23_header_image_wrapper_color', '' );
$wrapper_opacity = get_option( 'lab23_header_image_wrapper_opacity', '0.5' );

$mv_max_height = get_option( 'lab23_header_image_max_height', false );
?>
<div class="p-main-visual">
	<?php if ( $header_image || $has_video ) : ?>
		<div class="p-main-visual__inner p-main-visual__inner--pc">
			<?php if ( $has_video ) : ?>
				<video
					autoplay
					loop
					muted
					width="1200"
					poster="<?php if ( isset( $header_video_settings["posterUrl"] ) && ! empty ( $header_video_settings["posterUrl"] ) ) echo $header_video_settings["posterUrl"]; ?>"
				>
					<source
						src="<?php echo $header_video_settings["videoUrl"]; ?>"
						type="<?php if ( isset( $header_video_settings["mimeType"] ) && ! empty ( $header_video_settings["mimeType"] ) ) echo $header_video_settings["mimeType"]; ?>"
					/>
				</video>
			<?php else : ?>
				<img
					src="<?php echo $header_image; ?>"
					class="p-main-visual__img"
					height="<?php echo get_custom_header()->height; ?>"
					width="<?php echo get_custom_header()->width; ?>"
					alt="<?php _e( 'メインビジュアル', 'lab23' ); ?>"
					decoding="async"
				/>
			<?php endif; ?>
			<?php if ( ! empty( $header_text ) ) : ?>
				<div class="p-main-visual-text">
					<h2 class="p-main-visual-text__large-text">
						<?php echo nl2br( $header_text ); ?>
					</h2>
				</div>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php if ( $header_image_sp || $has_video ) : ?>
		<div class="p-main-visual__inner p-main-visual__inner--sp">
			<?php if ( $has_video ) : ?>
				<video
					autoplay
					loop
					muted
					width="1200"
					poster="<?php if ( isset( $header_image_sp[0] ) && ! empty ( $header_image_sp[0] ) ) echo $header_image_sp[0]; ?>"
				>
					<source
						src="<?php echo $header_video_settings["videoUrl"]; ?>"
						type="<?php if ( isset( $header_video_settings["mimeType"] ) && ! empty ( $header_video_settings["mimeType"] ) ) echo $header_video_settings["mimeType"]; ?>"
					/>
				</video>
			<?php else : ?>
				<img src="<?php echo $header_image_sp[0]; ?>" class="p-main-visual__img" height="<?php echo $header_image_sp[1]; ?>" width="<?php echo $header_image_sp[2] ?>" alt="<?php _e( 'メインビジュアル', 'lab23' ); ?>" />
			<?php endif; ?>
			<?php if ( ! empty( $header_text ) ) : ?>
				<div class="p-main-visual-text">
					<h2 class="p-main-visual-text__large-text">
						<?php echo nl2br( $header_text ); ?>
					</h2>
				</div>
			<?php endif; ?>
		</div>
	<?php endif; ?>
	<?php if ( ! empty( $wrapper_color ) ) : ?>
		<div class="p-main-visual-wrapper" style="background-color: <?php echo $wrapper_color; ?>; opacity: <?php echo $wrapper_opacity; ?>"></div>
	<?php endif; ?>
</div>