<?php

$num = get_option( 'lab23_related_post_length', 5 );

$current_post_id = get_the_ID();
$categories = get_the_category( $current_post_id );

$category_ID = array();

foreach( $categories as $category ) {
	array_push( $category_ID, $category->cat_ID );
}

$args = array(
	'post__not_in'    => array($current_post_id),
	'posts_per_page'  => $num,
	'category__in'    => $category_ID,
	'orderby'         => 'rand',
);

$my_query = new WP_Query($args);

$heading = esc_html( get_option( 'lab23_related_post_heading', '関連記事' ) );
?>
<?php if ( $my_query->have_posts() ) : ?>
	<div class="p-related-entries">
		<h2 class="p-related-entries__heading p-widget-ttl-main">
			<?php echo $heading; ?>
		</h2>
		<div class="p-related-entries__list">
			<?php while ( $my_query->have_posts() ) : $my_query->the_post(); ?>
				<?php
					$image_data = lab23_get_thumbnail_info( get_the_ID(), 'medium' );
					$title = get_the_title();
				?>
				<div class="p-related-entry-item">
					<div class="p-related-entry-item__thumb">
						<a href="<?php the_permalink(); ?>" class="p-related-entry-item__thumb-link">
							<img src="<?php echo $image_data[0]; ?>" alt="<?php echo $title; ?>" width="<?php echo $image_data[1]; ?>" height="<?php echo $image_data[2]; ?>" loading="lazy" />
						</a>
					</div>
					<div class="p-related-entry-item__content">
						<p class="p-related-entry-item__ttl">
							<a href="<?php the_permalink(); ?>" class="p-related-entry-item__link">
								<?php echo $title; ?>
							</a>
						</p>
						<p class="p-related-entry-item__excerpt">
							<?php echo lab23_get_excerpt( 140 ); ?>
						</p>
					</div>
				</div>
			<?php endwhile; ?>
		</div>
	</div>
<?php endif; ?>
<?php wp_reset_postdata(); ?>