<footer class="p-entry-footer">
	<div class="p-entry-footer__inner">
		<?php if ( is_single() && get_option( 'lab23_display_author_info', false ) ) : ?>
			<?php get_template_part( 'includes/content/author' ); ?>
		<?php endif; ?>
		<?php if ( get_option( 'lab23_share_btn_entry_bottom', 1 ) ) : ?>
			<?php get_template_part( 'includes/content/share-btn' ); ?>
		<?php endif; ?>
		<?php if ( get_post_type() === 'post' ) : ?>
			<div class="p-paging">
				<div class="p-paging__item p-paging__item--next">
					<?php $next_post = get_next_post(); ?>
					<?php if ( ! empty( $next_post ) ) : ?>
						<?php $next_url = get_permalink( $next_post->ID ); ?>
						<a href="<?php echo $next_url; ?>" class="p-paging__link">
							<p class="p-paging__text">次の投稿</p>
							<p class="p-paging__title"><?php echo lab23_mb_substr_text( $next_post->post_title, 100 ); ?></p>
						</a>
					<?php endif; ?>
				</div>
				<div class="p-paging__item p-paging__item--prev">
					<?php $previous_post = get_previous_post(); ?>
					<?php if ( ! empty( $previous_post ) ) : ?>
						<?php $prev_url = get_permalink( $previous_post->ID ); ?>
						<a href="<?php echo $prev_url; ?>" class="p-paging__link">
							<p class="p-paging__text">前の投稿</p>
							<p class="p-paging__title"><?php echo lab23_mb_substr_text( $previous_post->post_title, 100 ); ?></p>
						</a>
					<?php endif; ?>
				</div>
			</div>
			<?php if ( get_option( 'lab23_display_related_post' ) ) : ?>
				<?php get_template_part( 'includes/content/related-post' ); ?>
			<?php endif; ?>
			<?php if ( is_active_sidebar( 'entry-footer' ) ) : ?>
				<div class="p-entry-footer-widget">
					<?php dynamic_sidebar( 'entry-footer' ); ?>
				</div>
			<?php endif; ?>
		<?php endif; ?>
		<?php if (is_page()) : ?>
			<?php if ( is_active_sidebar( 'page-footer' ) ) : ?>
				<div class="p-entry-footer-widget">
					<?php dynamic_sidebar( 'page-footer' ); ?>
				</div>
			<?php endif; ?>

		<?php endif; ?>
		<div class="p-comment-area">
			<?php comments_template(); ?>
		</div>
	</div>
</footer>