<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$post_setting = get_post_meta( get_the_ID(), 'lab23_breadcrumbs_display', true );

if ( $post_setting === 'default' ) {
    if ( ! empty( get_option( 'lab23_hide_breadcrumbs_post', false ) ) ) {
        return;
    }
} elseif ( $post_setting === 'hide' ) {
    return;
}

$post_cat    = get_the_category(); // 投稿のカテゴリーを全部取得

if (empty($post_cat)) return;

$cat_id    = $post_cat[0]->cat_ID; // カテゴリーの取得

$args = array(
    'child_of'        => $cat_id,
    'hide_empty'    => 0
);
$cat_children = get_categories($args); // カテゴリーの子を全部取得

if (!empty($cat_children)) {
    //最初のカテゴリーに子があった場合
    $parent_id = $cat_id;
    foreach ($cat_children as $key) {
        $key_id = $key->term_id;
        if (in_category($key_id)) {
            //この投稿が子カテゴリーを設定している場合
            $child_id = $key_id;
            break;
        }
    }
} else {
    //最初のカテゴリーに子がなかった場合=>親がいるかもしれない
    $cat_info = get_category($cat_id);
    if ($cat_info->parent) {
        $parent_id = $cat_info->parent;
        $child_id = $cat_id;
    } else {
        // 親子関係なし
        $parent_id = $cat_id;
    }
}
$count = 1;

?>
<!-- パンくずリスト -->
<div class="c-breadcrumbs c-breadcrumbs--single" id="breadcrumbs">
    <ol class="c-breadcrumbs__list" itemscope itemtype="http://schema.org/BreadcrumbList">
        <li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="c-breadcrumbs__item">
            <a href="<?php echo LAB23_HOME_URL; ?>" itemprop="item">
                <svg xmlns="http://www.w3.org/2000/svg" width="65.523" height="59.759" viewBox="0 0 65.523 59.759">
                    <g transform="translate(0 0)">
                        <path d="M64.7,27.883,53.1,16.58a5.707,5.707,0,0,1-1.725-4.089v-8.1a2.6,2.6,0,0,0-2.242-2.63A2.5,2.5,0,0,0,46.37,4.25V9.086a.4.4,0,0,1-.675.285L38.332,2.2a7.756,7.756,0,0,0-10.79-.033l-26.7,25.7A2.6,2.6,0,0,0,.5,31.305a2.5,2.5,0,0,0,3.706.264l26.8-25.8a2.744,2.744,0,0,1,3.833.012L61.306,31.559a2.5,2.5,0,0,0,3.652-.174,2.591,2.591,0,0,0-.259-3.5" />
                        <path d="M31.121,12.135l-21.076,20.2a2.642,2.642,0,0,0-.815,1.908V57.116a2.643,2.643,0,0,0,2.644,2.643H23.586a2.643,2.643,0,0,0,2.643-2.643v-9.65a2.644,2.644,0,0,1,2.644-2.644h7.778a2.644,2.644,0,0,1,2.644,2.644v9.65a2.643,2.643,0,0,0,2.643,2.643H53.65a2.643,2.643,0,0,0,2.644-2.643V34.234a2.645,2.645,0,0,0-.8-1.893L34.8,12.151a2.644,2.644,0,0,0-3.675-.016" />
                    </g>
                </svg>
                <span itemprop="name">
                    ホーム
                </span>
            </a>
            <meta itemprop="position" content="1" />
        </li>
        <?php if (!empty($parent_id)) : ?>
            <li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="c-breadcrumbs__item"><a href="<?php echo get_category_link($parent_id); ?>" itemprop="item"><span itemprop="name"><?php echo esc_html(get_cat_name($parent_id)); ?></span></a>
                <meta itemprop="position" content="2" />
            </li>
        <?php $count++;
        endif; ?>
        <?php if (!empty($child_id)) : ?>
            <li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="c-breadcrumbs__item"><a href="<?php echo get_category_link($child_id); ?>" itemprop="item"><span itemprop="name"><?php echo esc_html(get_cat_name($child_id)); ?></span></a>
                <meta itemprop="position" content="3" />
            </li>
            <?php $count++; ?>
        <?php endif; ?>
    </ol>
</div>