<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$post_setting = get_post_meta( get_the_ID(), 'lab23_breadcrumbs_display', true );

if ( $post_setting === 'default' ) {
    if ( ! empty( get_option( 'lab23_hide_breadcrumbs_page', false ) ) ) {
        return;
    }
} elseif ( $post_setting === 'hide' ) {
    return;
}

$ancestors_array = array_reverse(get_post_ancestors($post->ID));

$count = 2;
?>
<div class="c-breadcrumbs c-breadcrumbs--page" id="breadcrumbs-page">
	<ol class="c-breadcrumbs__list" itemscope itemtype="http://schema.org/BreadcrumbList">
		<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="c-breadcrumbs__item">
			<a href="<?php echo LAB23_HOME_URL; ?>" itemprop="item">
				<svg xmlns="http://www.w3.org/2000/svg" width="65.523" height="59.759" viewBox="0 0 65.523 59.759">
					<g transform="translate(0 0)">
						<path d="M64.7,27.883,53.1,16.58a5.707,5.707,0,0,1-1.725-4.089v-8.1a2.6,2.6,0,0,0-2.242-2.63A2.5,2.5,0,0,0,46.37,4.25V9.086a.4.4,0,0,1-.675.285L38.332,2.2a7.756,7.756,0,0,0-10.79-.033l-26.7,25.7A2.6,2.6,0,0,0,.5,31.305a2.5,2.5,0,0,0,3.706.264l26.8-25.8a2.744,2.744,0,0,1,3.833.012L61.306,31.559a2.5,2.5,0,0,0,3.652-.174,2.591,2.591,0,0,0-.259-3.5" />
						<path d="M31.121,12.135l-21.076,20.2a2.642,2.642,0,0,0-.815,1.908V57.116a2.643,2.643,0,0,0,2.644,2.643H23.586a2.643,2.643,0,0,0,2.643-2.643v-9.65a2.644,2.644,0,0,1,2.644-2.644h7.778a2.644,2.644,0,0,1,2.644,2.644v9.65a2.643,2.643,0,0,0,2.643,2.643H53.65a2.643,2.643,0,0,0,2.644-2.643V34.234a2.645,2.645,0,0,0-.8-1.893L34.8,12.151a2.644,2.644,0,0,0-3.675-.016" />
					</g>
				</svg>
				<span itemprop="name">
					ホーム
				</span>
			</a>
			<meta itemprop="position" content="1" />
		</li>
		<?php if (!empty($ancestors_array)) : ?>
			<?php foreach ($ancestors_array as $ancestor_id) : ?>
				<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="c-breadcrumbs__item">
					<a href="<?php echo get_page_link($ancestor_id); ?>" itemprop="item"><span itemprop="name"><?php echo esc_html(get_post($ancestor_id)->post_title); ?></span></a>
					<meta itemprop="position" content="<?php echo $count; ?>" />
				</li>
				<?php $count++; ?>
			<?php endforeach; ?>
		<?php endif; ?>
		<li itemprop="itemListElement" itemscope itemtype="http://schema.org/ListItem" class="c-breadcrumbs__item c-breadcrumbs__item--title"><span itemprop="name"><?php the_title(); ?></span>
			<meta itemprop="position" content="<?php echo $count; ?>" />
		</li>
	</ol>
</div>