<?php

$design = get_option( 'lab23_archive_design', 'card' );
$title = isset( $args ) && isset( $args['title'] ) ? $args['title'] : get_the_archive_title();
$column = get_option( 'lab23_column_archive', '2columns' );

$pager_design = get_option( 'lab23_archive_pager', 'border' );

$is_home = is_home() && $paged < 2;

?>
<?php get_header( null, array( 'column' => $column ) ); ?>
<?php if ( $is_home ) : ?>
	<?php get_template_part( 'includes/home/main-visual' ); ?>
	<?php if ( get_option( 'lab23_slider_id_list', false ) ) : ?>
		<?php get_template_part( 'includes/home/slider' ); ?>
	<?php endif; ?>
<?php endif; ?>
<div class="l-content-wrap l-content-wrap--<?php echo $column; ?>">
	<div class="l-content-wrap__inner l-content-wrap__inner--<?php echo $design; ?>">
		<div class="l-content">
			<main class="l-content-main">
				<div class="l-content-main__inner l-content-main__inner--entries">
					<?php if ( $is_home && is_active_sidebar( 'home' ) ) : ?>
						<div class="p-home-widget">
							<?php dynamic_sidebar('home'); ?>
						</div>
					<?php endif; ?>
					<?php if ( ! empty( $title ) ) : ?>
						<h1 class="p-archive-ttl">
							<?php echo $title; ?>
						</h1>
					<?php endif; ?>
					<?php get_template_part( 'includes/archive/entries', $design ); ?>
					<div class="p-pager p-pager--<?php echo $pager_design; ?>">
						<?php echo paginate_links(array(
							'type' => 'list',
							'prev_text' => '',
							'next_text' => '',
						)); ?>
					</div>
				</div>
			</main>
			<?php if ( $column === '2columns' ) : ?>
				<?php get_sidebar(); ?>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php get_footer(); ?>