<div class="p-information">
	<?php if (have_posts()) : ?>
		<?php while (have_posts()) : the_post(); ?>
			<?php
			$category = get_the_category();
			$has_excerpt = get_option( 'lab23_display_excerpt_archive', false );
			?>
			<div class="p-information-item">
				<div class="p-information-item__inner <?php if ( $has_excerpt ) echo 'p-information-item__inner--has-excerpt' ?>">
					<div class="p-information-item__info">
						<div class="p-information-item__date">
							<span class="p-information-item__post-date">
								<time datetime="<?php the_time('Y-m-d'); ?>"><?php the_time('Y.m.d'); ?></time>
							</span>
						</div>
						<div class="p-information-item__cat">
							<?php if ($category) : ?>
								<?php foreach ($category as $cat) : ?>
									<a href="<?php echo get_category_link($cat->term_id); ?>" class="p-information-item__cat-item"><?php echo $cat->name; ?></a>
								<?php endforeach; ?>
							<?php endif; ?>
						</div>
					</div>
					<div class="p-information-item__content">
						<p class="p-information-item__ttl">
							<a href="<?php the_permalink(); ?>" class="p-information-item__inner">
								<?php echo lab23_mb_substr_text(get_the_title(), 118); ?>
							</a>
						</p>
						<?php if ( $has_excerpt ) : ?>
							<p class="p-information-item__excerpt">
								<?php echo lab23_get_excerpt( 170 ); ?>
							</p>
						<?php endif; ?>
					</div>
				</div>
			</div>
		<?php endwhile; ?>
	<?php endif; ?>
</div>