<?php
$infeed_adsense_code = get_option( 'lab23_infeed_adsense_code' );
$count = 1;
$infeed_num = ! empty( get_option( 'lab23_infeed_adsense_code_num' ) ) 
			? lab23_comma_separated_to_array( get_option( 'lab23_infeed_adsense_code_num' ) )
			: null;

$is_first_view = true;

if ( is_home() && $paged < 2 ) {
	if ( has_custom_header() ) {
		$is_first_view = false;
	}

	if ( is_active_sidebar( 'home' ) ) {
		$is_first_view = false;
	}
}

?>
<div class="p-entries">
	<?php if ( have_posts() ) : ?>
		<?php while ( have_posts() ) : the_post(); ?>
			<?php
			$category = get_the_category();
			$title = lab23_mb_substr_text( get_the_title(), 118 );
			$image_data = lab23_get_thumbnail_info( get_the_ID(), 'medium_large' );
			$has_excerpt = get_option( 'lab23_display_excerpt_archive', false );
			?>
			<?php if( ! empty( $infeed_num ) && in_array( $count, $infeed_num, false ) ): ?>
				<div class="p-entry-item">
					<?php echo lab23_infeed_ad_html( $infeed_adsense_code ); ?>
				</div>
			<?php endif; ?>
			<div class="p-entry-item">
				<a href="<?php the_permalink(); ?>" class="p-entry-item__inner">
					<div class="p-entry-item__thumb">
						<img src="<?php echo $image_data[0]; ?>" alt="<?php echo $title; ?>" width="<?php echo $image_data[1]; ?>" height="<?php echo $image_data[2]; ?>" <?php if ( $count > 2 || ! $is_first_view ) echo 'loading="lazy"'; ?>/>
					</div>
					<div class="p-entry-item__content">
						<h2 class="p-entry-item__ttl">
							<?php echo $title; ?>
						</h2>
						<?php if ( $has_excerpt ) : ?>
							<p class="p-entry-item__excerpt">
								<?php echo lab23_get_excerpt( 140 ); ?>
							</p>
						<?php endif; ?>
						<div class="p-entry-item__info">
							<div class="p-entry-item__cat">
								<?php if ($category) : ?>
									<?php foreach ($category as $cat) : ?>
										<span class="p-entry-item__cat-item"><?php echo $cat->name; ?></span>
									<?php endforeach; ?>
								<?php endif; ?>
							</div>
							<div class="p-entry-item__date">
								<span class="p-entry-item__post-date">
									<time datetime="<?php the_time('Y-m-d'); ?>"><?php the_time('Y.m.d'); ?></time>
								</span>
							</div>
						</div>
					</div>
				</a>
			</div>
			<?php $count++; ?>
		<?php endwhile; ?>
	<?php endif; ?>
</div>