<?php
/**
 * ユーザープロフィールの項目のカスタマイズ
 */
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if( !function_exists( 'lab23_user_meta' ) ) {
    function lab23_user_meta($wb) {
		//項目の追加
		$wb['twitter']		= __( 'X（旧Twitter）のURL', 'lab23' );
		$wb['facebook']		= __( 'facebookのURL', 'lab23');
		$wb['instagram']	= __( 'instagramのURL', 'lab23' );
		$wb['youtube_ch']	= __( 'YouTubeチャンネルのURL', 'lab23' );

		return $wb;
    }
    add_filter( 'user_contactmethods', 'lab23_user_meta', 10, 1 );
}

if ( ! function_exists( 'lab23_get_the_author_avatar_url' ) ) {
	function lab23_get_the_author_avatar_url( $user_id = '' ) {

		if ( empty( $user_id ) ) return false;

		return esc_url( get_the_author_meta( 'upladed_avatar', $user_id ) );

	}
}

if ( ! function_exists( 'lab23_add_avatar_to_user_profile' ) ) {
	function lab23_add_avatar_to_user_profile( $description, $user ) {

		ob_start();
		?>
		<div class="user-profile-picture__avatar-uploader">
			<h4 style="margin-bottom: 0;"><?php _e( 'アバターをアップロード', 'lab23' ); ?></h4>
			<div class="lab23-media-uploader">
				<div class="lab23-image-preview">
					<img src="<?php echo esc_url( get_the_author_meta( 'upladed_avatar', $user->ID ) ); ?>" class="lab23-image-preview__img" style="max-width: 150px;">
				</div>
				<div class="lab23-input">
					<input type="hidden" name="upladed_avatar" class="lab23-meta-image regular-text" value="<?php echo lab23_get_the_author_avatar_url($user->ID); ?>" title="プロフィール画像を選択">
				</div>
				<div class="lab23-media-upload-btns">
					<input type="button" class="button lab23-image-upload" value="メディアをアップロード">
					<input type="button" class="button lab23-image-reset" value="削除">
				</div>
				<p class="description">
					<?php _e( 'Gravatarよりこちらのプロフィール画像が優先されます。推奨サイズ: 240×240px', 'lab23' ); ?>
				</p>
			</div>
		</div>
		<?php
		$form = ob_get_contents();
		ob_clean();

		return $form;
	}
}
add_filter( 'user_profile_picture_description', 'lab23_add_avatar_to_user_profile', 10, 2 );

if ( ! function_exists( 'lab23_update_avatar_to_user_profile' ) ) {
	function lab23_update_avatar_to_user_profile( $user_id ) {
		
		if ( current_user_can( 'edit_user',$user_id ) ){

			if ( isset( $_POST['upladed_avatar'] ) ) {
				update_user_meta($user_id, 'upladed_avatar', $_POST['upladed_avatar']);
			}
		}
	}
}
add_action( 'profile_update', 'lab23_update_avatar_to_user_profile' );
	
if ( !function_exists( 'lab23_get_uploaded_user_avatar' ) ) {
	function lab23_get_uploaded_user_avatar( $avatar, $id_or_email, $size, $default, $alt ) {
		if ( is_numeric( $id_or_email ) ) {

			$user_id = (int) $id_or_email;

		} elseif ( is_string( $id_or_email ) && ( $user = get_user_by( 'email', $id_or_email ) ) ) {
			
			$user_id = $user->ID;
		
		} elseif ( is_object( $id_or_email ) && ! empty( $id_or_email->user_id ) ) {
			
			$user_id = (int) $id_or_email->user_id;
		
		}

		if ( empty( $user_id ) ) {
			return $avatar;
		}
		
		if ( lab23_get_the_author_avatar_url( $user_id ) ) {
			$alt			= ! empty( $alt ) ? $alt : get_the_author_meta( 'display_name', $user_id );
			$author_class	= is_author( $user_id ) ? ' current-author' : '' ;
			$avatar			= '<img alt="' . esc_attr( $alt ) . '" src="' . esc_url( lab23_get_the_author_avatar_url( $user_id ) ) . '" class="avatar avatar-' . $size . $author_class . ' photo" height="' . $size . '" width="' . $size . '" />';
		}
		
		return $avatar;
	}
}
add_filter( 'get_avatar' , 'lab23_get_uploaded_user_avatar' , 1 , 5 );

if ( !function_exists( 'lab23_get_uploaded_user_avatar_url' ) ) {
	function lab23_get_uploaded_user_avatar_url( $avatar_url, $user_id ) {
		
		$uploaded_avatar = lab23_get_the_author_avatar_url( $user_id );
		
		if ( ! empty( $uploaded_avatar ) ) {
			return $uploaded_avatar;
		}
		
		return $avatar_url;
	}
}
add_filter( 'get_avatar_url' , 'lab23_get_uploaded_user_avatar_url' , 1, 2 );