<?php

// タイトルのカスタマイズ
if (!function_exists('lab23_document_title_parts')) {
	function lab23_document_title_parts($title)
	{
		if (is_singular()) {

			$post_id			= get_the_ID();
			$seo_title			= get_post_meta($post_id, 'lab23_seo_title', true);
			$remove_sitename	= get_post_meta($post_id, 'lab23_seo_title_remove_sitename', true);

			if (!empty($seo_title)) {
				$title['title'] = $seo_title;
			}

			if($remove_sitename) {
				$title['site'] = '';
			}

			if (is_front_page()) {
				if (empty($seo_title)) {
					$title['title'] = get_the_title($post_id);
				}

				if ($remove_sitename) {
					$title['tagline'] = '';
				} else {
					$title['tagline'] = get_bloginfo('name');
				}
			}
		}

		return $title;
	}
	add_filter('document_title_parts', 'lab23_document_title_parts', 10, 1);
}