<?php

/**
 * タグ追加設定
 */
if (!defined('ABSPATH')) {
	exit;
}

//カスタムフィールドの追加
if (!function_exists('lab23_add_tag_metabox')) {

	function lab23_add_tag_metabox()
	{
		add_meta_box('lab23_tag', __('タグ追加設定', 'lab23'), 'lab23_tag_metabox', array('page', 'post'), 'normal', 'default');
	}
	add_action('admin_menu', 'lab23_add_tag_metabox', 1);
}

if (!function_exists('lab23_tag_metabox')) {
	function lab23_tag_metabox()
	{
		$post_id	= get_the_ID();
		$header_tag = get_post_meta($post_id, 'lab23_tag_header', true);
		$footer_tag	= get_post_meta($post_id, 'lab23_tag_footer', true);

		wp_nonce_field('wp-nonce-key', '_wp_nonce_lab23');
?>
		<div class="lab23-metabox-group">
			<div class="lab23-metabox-block">
				<div class="lab23-metabox-item">
					<p class="lab23-metabox-label">
						<label for="lab23_tag_header">ヘッダーにコードを追加</label>
					</p>
					<textarea name="lab23_tag_header" id="lab23_tag_header"><?php echo $header_tag; ?></textarea>
				</div>
				<div class="lab23-metabox-item">
					<p class="lab23-metabox-label">
						<label for="lab23_tag_footer">フッターにコードを追加</label>
					</p>
					<textarea name="lab23_tag_footer" id="lab23_tag_footer"><?php echo $footer_tag; ?></textarea>
				</div>
			</div>
		</div>
<?php
	}
}

if (!function_exists('lab23_save_tag_metabox')) {
	function lab23_save_tag_metabox($post_id)
	{
		if (!isset($_POST['_wp_nonce_lab23']) || !$_POST['_wp_nonce_lab23']) return;
		if (!check_admin_referer('wp-nonce-key', '_wp_nonce_lab23')) return;

		lab23_save_meta_value($post_id, 'lab23_tag_header', 'lab23_tag_header');
		lab23_save_meta_value($post_id, 'lab23_tag_footer', 'lab23_tag_footer');
	}
	add_action('save_post', 'lab23_save_tag_metabox');
}
