<?php
/**
 * 目次関連設定
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function lab23_add_mokuji_fields() {
	add_meta_box( 'lab23_mokuji', '目次の非表示設定', 'lab23_insert_mokuji_fields', array( 'post', 'page' ), 'normal', 'default' );
}
add_action( 'admin_menu', 'lab23_add_mokuji_fields', 1 );

// カスタムフィールドの入力エリア
function lab23_insert_mokuji_fields() {

    $post_id        = get_the_ID();
    $mokuji_range   = get_post_meta( $post_id, 'lab23_mokuji_range', true) ?: 'default';

	if ( get_post_meta( $post_id, 'lab23_hide_mokuji', true ) == "1" ) {
		$mokuji_hide_check = "checked";
	} else {
		$mokuji_hide_check = "";
	}
    wp_nonce_field( 'wp-nonce-key', '_wp_nonce_lab23' );
?>
<div class="lab23-metabox-group">
    <div class="lab23-metabox-block">
        <div class="lab23-metabox-item">
            <label>
                <input type="checkbox" name="lab23_hide_mokuji" value="1" <?php echo $mokuji_hide_check; ?>>この投稿で目次を非表示にする。
            </label>
        </div>
        <div class="lab23-metabox-item">
            <p class="lab23-metabox-label"><label for="lab23_mokuji_range">目次に含める見出しの深さ</label></p>
            <select name="lab23_mokuji_range" id="lab23_mokuji_range">
                <option value="default" <?php if ( $mokuji_range === 'default') echo 'selected'; ?>>デフォルト</option>
                <option value="2" <?php if ( $mokuji_range === '2' ) echo 'selected'; ?>>h2見出しまで</option>
                <option value="3" <?php if ( $mokuji_range === '3' ) echo 'selected'; ?>>h3見出しまで</option>
                <option value="4" <?php if ( $mokuji_range === '4' ) echo 'selected'; ?>>h4見出しまで</option>
                <option value="5" <?php if ( $mokuji_range === '5' ) echo 'selected'; ?>>h5見出しまで</option>
                <option value="6" <?php if ( $mokuji_range === '6' ) echo 'selected'; ?>>h6見出しまで</option>
            </select>
        </div>
    </div>
</div>
<?php
}

if (!function_exists('lab23_save_mokuji_metabox')) {
    function lab23_save_mokuji_metabox($post_id)
    {
        if ( ! isset( $_POST['_wp_nonce_lab23'] ) || ! $_POST['_wp_nonce_lab23']) return;
        if ( ! check_admin_referer( 'wp-nonce-key', '_wp_nonce_lab23' ) ) return;

        lab23_save_meta_boolean_value( $post_id, 'lab23_hide_mokuji', 'lab23_hide_mokuji' );
        lab23_save_meta_value( $post_id, 'lab23_mokuji_range', 'lab23_mokuji_range' );
    }
    add_action('save_post', 'lab23_save_mokuji_metabox');
}