<?php

/**
 * インデックス設定
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

//カスタムフィールドの追加
if ( ! function_exists( 'lab23_add_index_metabox' ) ) {

    function lab23_add_index_metabox() {
        add_meta_box( 'lab23_index', __( 'インデックス設定', 'lab23' ), 'lab23_index_metabox', array( 'page', 'post' ), 'normal', 'default' );
    }
    add_action( 'admin_menu', 'lab23_add_index_metabox', 1 );
}

if ( ! function_exists( 'lab23_index_metabox' ) ) {
    function lab23_index_metabox() {
        $post_id = get_the_ID();
        $noindex = get_post_meta( $post_id, 'lab23_noindex', true );
        $nofollow = get_post_meta( $post_id, 'lab23_nofollow', true );

        wp_nonce_field('wp-nonce-key', '_wp_nonce_lab23');
?>
        <div class="lab23-metabox-group">
            <p class="lab23-metabox-desc">この投稿のインデックス設定ができます。</p>
            <div class="lab23-metabox-flex">
                <div class="lab23-metabox-item">
                    <label>
                        <input type="checkbox" name="lab23_noindex" id="lab23_noindex" <?php if ($noindex) echo 'checked'; ?>> noindexにする
                    </label>
                </div>
                <div class="lab23-metabox-item">
                    <label>
                        <input type="checkbox" name="lab23_nofollow" id="lab23_nofollow" <?php if ($nofollow) echo 'checked'; ?>> nofollowにする
                    </label>
                </div>
            </div>
        </div>

<?php
    }
}

if ( ! function_exists( 'lab23_save_index_metabox' ) ) {
    function lab23_save_index_metabox($post_id) {
        if ( ! isset( $_POST['_wp_nonce_lab23'] ) || ! $_POST['_wp_nonce_lab23'] ) return;
        if ( ! check_admin_referer( 'wp-nonce-key', '_wp_nonce_lab23' ) ) return;

        lab23_save_meta_boolean_value( $post_id, 'lab23_noindex', 'lab23_noindex' );
        lab23_save_meta_boolean_value( $post_id, 'lab23_nofollow', 'lab23_nofollow' );
    }
    add_action('save_post', 'lab23_save_index_metabox');
}
