<?php

/**
 * 広告タグの表示設定
 */
if (!defined('ABSPATH')) {
    exit;
}

//カスタムフィールドの追加
if (!function_exists('lab23_add_advertisement_tag_metabox')) {

    function lab23_add_advertisement_tag_metabox()
    {
        add_meta_box( 'lab23_ad_tag', __( '広告表記設定', 'lab23' ), 'lab23_advertisement_tag_metabox', array( 'page', 'post' ), 'normal', 'default' );
    }
    add_action( 'admin_menu', 'lab23_add_advertisement_tag_metabox', 1 );
}

if (!function_exists('lab23_advertisement_tag_metabox')) {
    function lab23_advertisement_tag_metabox()
    {
        $post_id			= get_the_ID();
        $ad_tag_settings	= get_post_meta( $post_id, 'lab23_ad_tag', true );

        wp_nonce_field( 'wp-nonce-key', '_wp_nonce_lab23' );
?>
        <div class="lab23-metabox-group">
			<div class="lab23-metabox-block">
				<div class="lab23-metabox-item">
					<p class="lab23-metabox-label"><label for="lab23_ad_tag">タイトル下に広告表記を表示する</label></p>
					<select name="lab23_ad_tag" id="lab23_ad_tag">
						<option value="default" <?php if ($ad_tag_settings === 'default') echo 'selected'; ?>>デフォルト</option>
						<option value="show" <?php if ($ad_tag_settings === 'show') echo 'selected'; ?>>表示</option>
						<option value="hide" <?php if ($ad_tag_settings === 'hide') echo 'selected'; ?>>非表示</option>
					</select>
				</div>
			</div>
        </div>

<?php
    }
}

if (!function_exists('lab23_save_advertisement_tag_metabox')) {
    function lab23_save_advertisement_tag_metabox($post_id)
    {
        if (!isset($_POST['_wp_nonce_lab23']) || !$_POST['_wp_nonce_lab23']) return;
        if (!check_admin_referer('wp-nonce-key', '_wp_nonce_lab23')) return;

        lab23_save_meta_value($post_id, 'lab23_ad_tag', 'lab23_ad_tag');
    }
    add_action('save_post', 'lab23_save_advertisement_tag_metabox');
}
