<?php

/**
 * 抜粋関連の関数
 */
if (!defined('ABSPATH')) {
	exit;
}

/**
 * 抜粋、descriptionなどを無害化
 *
 * @param string $content 抜粋、descriptionなど
 * @param boolean $do_shortcode ショートコードを実行するか
 * @return string 無害化されたテキスト
 * @version 0.1.0
 */
if (!function_exists('lab23_sanitize_excerpt')) {
	function lab23_sanitize_excerpt($content, $do_shortcode = true)
	{

		if ($do_shortcode) $content = do_shortcode($content);

		$content = strip_shortcodes($content); //展開できなかったショートコードは削除
		$content = str_replace( '[mokuji]', '', $content );
		$content = strip_tags($content);
		$content = lab23_delete_breaks($content);
		$content = lab23_trim_same_space($content);

		return $content;
	}
}

/**
 * ショートコード展開後の抜粋を取得
 *
 * @param int $length 最大文字数
 * @param int $post_id 記事ID
 * @param bool $do_shortcode ショートコードを展開するか
 * @return string 記事の抜粋
 * @version 0.1.0
 */
if (!function_exists('lab23_get_excerpt')) {
	function lab23_get_excerpt($length = 140, $post_id = null, $do_shortcode = true)
	{
		try {
			if ($post_id) {
				$post = get_post($post_id);
			} else {
				global $post;
			}

			$suffix = '...';
			$content = $post->post_content;
			$content = lab23_sanitize_excerpt($content, $do_shortcode);
			$content = mb_strimwidth($content, 0, $length, $suffix, 'UTF-8');

			return $content;
		} catch (Exception $error) {
			return '';
		}
		
	}
}

/**
 * ループ外から抜粋を取得する関数
 *
 * @param int $post_id 記事ID
 * @param int $length 最大文字数
 * @param bool $do_shortcode ショートコードを展開するか
 * @return string 記事の抜粋
 * @version 0.1.0
 */
if (!function_exists('lab23_get_the_excerpt_outside')) {
	function lab23_get_the_excerpt_outside($post_id, $length = 140)
	{
		try {
			$output = get_the_excerpt($post_id);
			$output = str_replace( '[toc]', '', $output );
			$output = str_replace( '[mokuji]', '', $output );
			if ($length) $output = mb_strimwidth($output, 0, $length, "...", 'UTF-8');

			return $output;

		} catch (Exception $error) {
			
			return '';
			
		}
	}
}
