<?php
/**
 * カスタマイザーの設定
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( ! function_exists( 'lab23_customizer_register_header_image' ) ) {
	function lab23_customizer_register_header_image( $wp_customize ) {
			$wp_customize->add_setting( 'lab23_sp_header_image', array(
				'sanitize_callback' => 'lab23_sanitize_cropped_image',
				'type' => 'theme_mod',
			) );
			$wp_customize->add_control( new WP_Customize_Cropped_Image_Control($wp_customize,'lab23_sp_header_image', array(
				'label'			=> __( 'モバイルヘッダー画像', 'lab23' ),
				'description'	=> __( 'モバイル用のヘッダー画像を設定できます。<br>切り抜いた場合800x700になります。', 'lab23' ),
				'section'		=> 'header_image',
				'settings'		=> 'lab23_sp_header_image',
				'width' 		=> 800,
				'height'		=> 700,
				'flex_width'	=> true,
				'flex_height'	=> true,
			) ) );
	}
	add_action( 'customize_register', 'lab23_customizer_register_header_image' );
}
/*
if( ! function_exists( 'lab23_remove_header_video_option' ) ) {
	function lab23_remove_header_video_option($wp_customize) {
		// ヘッダー動画のアップロードオプションを削除
		$wp_customize->remove_control('header_video');

		// YouTubeのURL入力欄も削除
		$wp_customize->remove_control('external_header_video');
	}
	add_action('customize_register', 'lab23_remove_header_video_option');
}
*/

if( ! function_exists( 'lab23_my_customize_header_media' ) ) {
	function lab23_my_customize_header_media($wp_customize) {
		// 「ヘッダーメディア」セクションに説明を追加
		$homepage_settings_url = admin_url('customize.php?autofocus[section]=static_front_page'); 
		$wp_customize->get_section('header_image')->description = 'このヘッダーメディアは<a href="' . esc_url($homepage_settings_url) . '">「ホームページの表示」</a>が<b>「最新の投稿」</b>を指定している場合と、<b>「固定ページ」</b>を指定している場合は<b>「投稿ページ」</b>に指定したページ</i>で表示されます。<br><br><b>「固定ページ」</b>を指定している場合の<b>ホームページ</b>のヘッダー画像は指定した固定ページの編集で<b>「メインビジュアル」等の</b>ブロックを設定してください。<br><br><hr>ファイルサイズが大きい動画ファイルは表示できません。また、YouTube動画の設定によっては表示できない場合もあります。<br><hr>';
	}
	add_action('customize_register', 'lab23_my_customize_header_media');
}