<?php

/**
 * カスタマイザーの設定
 */
if (!defined('ABSPATH')) {
	exit;
}
/**
 * カラーの設定
 */
if ( ! function_exists( 'lab23_customizer_register_color' )) {
	function lab23_customizer_register_color( $wp_customize ) {
		$wp_customize->add_setting( 'lab23_main_color', array(
			'type'				=> 'option',
			'default'			=> '#333',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_main_color', array(
			'label'		=> __( 'メインカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_main_color',
		) ) );

		$wp_customize->add_setting( 'lab23_text_color_on_main_color', array(
			'type'				=> 'option',
			'default'			=> '#fff',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_text_color_on_main_color', array(
			'label'		=> __( 'メインカラーに載せる文字色', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_text_color_on_main_color',
		) ) );

		$wp_customize->add_setting( 'lab23_light_color', array(
			'type'				=> 'option',
			'default'			=> '#f7f7f7',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_light_color', array(
			'label'		=> __( '薄い色', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_light_color',
		) ) );

		$wp_customize->add_setting( 'lab23_text_color', array(
			'type'				=> 'option',
			'default'			=> '#333',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_text_color', array(
			'label'		=> __( 'テキストカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_text_color',
		) ) );

		$wp_customize->add_setting( 'lab23_border_color', array(
			'type'				=> 'option',
			'default'			=> '#eee',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_border_color', array(
			'label'			=> __( 'ボーダーカラー', 'lab23' ),
			'description'	=> __( '枠線や入力フォーム、区切り線などに使用されるボーダーの色', 'lab23' ),
			'section'		=> 'colors',
			'settings'		=> 'lab23_border_color',
		) ) );

		$wp_customize->add_setting( 'lab23_header_bg_color', array(
			'type'				=> 'option',
			'default'			=> '#fff',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_header_bg_color', array(
			'label'		=> __( 'ヘッダーの背景色', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_header_bg_color',
		) ) );
		$wp_customize->add_setting( 'lab23_header_color', array(
			'type'				=> 'option',
			'default'			=> '#333',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_header_color', array(
			'label'		=> __( 'ヘッダーのテキストカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_header_color',
		) ) );
		
		// Hamburger
		$wp_customize->add_setting( 'lab23_hamburger_color', array(
			'type'				=> 'option',
			'default'			=> '#fff',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_hamburger_color', array(
			'label'		=> __( 'ハンバーガーメニューのテキストカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_hamburger_color',
		) ) );
		$wp_customize->add_setting( 'lab23_hamburger_bg_color', array(
			'type'				=> 'option',
			'default'			=> '#111',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_hamburger_bg_color', array(
			'label'		=> __( 'ハンバーガーメニューの背景色', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_hamburger_bg_color',
		) ) );

		// Sub Menu
		$wp_customize->add_setting( 'lab23_submenu_bg_color', array(
			'type'				=> 'option',
			'default'			=> '#eee',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_submenu_bg_color', array(
			'label'		=> __( 'サブメニューの背景色', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_submenu_bg_color',
		) ) );
		$wp_customize->add_setting( 'lab23_submenu_text_color', array(
			'type'				=> 'option',
			'default'			=> '#333',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_submenu_text_color', array(
			'label'		=> __( 'サブメニューのテキストカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_submenu_text_color',
		) ) );
		$wp_customize->add_setting( 'lab23_submenu_border_color', array(
			'type'				=> 'option',
			'default'			=> '#ccc',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_submenu_border_color', array(
			'label'		=> __( 'サブメニューのボーダーカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_submenu_border_color',
		) ) );
		

		$wp_customize->add_setting( 'lab23_link_color', array(
			'type'				=> 'option',
			'default'			=> '#247db4',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_link_color', array(
			'label'		=> __( '本文のリンクカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_link_color',
		) ) );
		$wp_customize->add_setting( 'lab23_category_color', array(
			'type'				=> 'option',
			'default'			=> '#eee',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_category_color', array(
			'label'		=> __( 'カテゴリーのラベルカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_category_color',
		) ) );
		$wp_customize->add_setting( 'lab23_category_text_color', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_hex_color',
			'default'			=> '#333',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_category_text_color', array(
			'label'		=> __( 'カテゴリーの文字色', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_category_text_color',
		) ) );
		$wp_customize->add_setting( 'lab23_tag_color', array(
			'type'				=> 'option',
			'default'			=> '#eee',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_tag_color', array(
			'label'		=> __( 'タグのラベルカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_tag_color',
		) ) );
		$wp_customize->add_setting( 'lab23_tag_text_color', array(
			'type'				=> 'option',
			'sanitize_callback'	=> 'sanitize_hex_color',
			'default'			=> '#333',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_tag_text_color', array(
			'label'		=> __( 'タグの文字色', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_tag_text_color',
		) ) );
		$wp_customize->add_setting( 'lab23_comment_btn_color', array(
			'type'				=> 'option',
			'default'			=> '#d31111',
			'sanitize_callback'	=> 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_comment_btn_color', array(
			'label'		=> __( 'コメント送信ボタンカラー', 'lab23' ),
			'section'	=> 'colors',
			'settings'	=> 'lab23_comment_btn_color',
		) ) );
		$wp_customize->add_setting( 'lab23_page_top_button_color', array(
			'type'              => 'option',
			'default'           => '#111',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_page_top_button_color', array(
			'label'     => __( 'ページトップボタンの色', 'lab23' ),
			'section'   => 'colors',
			'settings'  => 'lab23_page_top_button_color',
			'priority'  => 10,
		) ) );
		$wp_customize->add_setting( 'lab23_footer_widget_bg_color', array(
			'type'              => 'option',
			'default'           => '#eee',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_footer_widget_bg_color', array(
			'label'     => __( 'フッターウィジェットの背景色', 'lab23' ),
			'section'   => 'colors',
			'settings'  => 'lab23_footer_widget_bg_color',
			'priority'  => 10,
		) ) );
		$wp_customize->add_setting( 'lab23_footer_widget_text_color', array(
			'type'              => 'option',
			'default'           => '#333',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_footer_widget_text_color', array(
			'label'     => __( 'フッターウィジェットの文字色', 'lab23' ),
			'section'   => 'colors',
			'settings'  => 'lab23_footer_widget_text_color',
			'priority'  => 10,
		) ) );
		$wp_customize->add_setting( 'lab23_footer_nav_bg_color', array(
			'type'              => 'option',
			'default'           => '#f5f5f5',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_footer_nav_bg_color', array(
			'label'     => __( 'フッターメニューの背景色', 'lab23' ),
			'section'   => 'colors',
			'settings'  => 'lab23_footer_nav_bg_color',
			'priority'  => 10,
		) ) );
		$wp_customize->add_setting( 'lab23_footer_nav_text_color', array(
			'type'              => 'option',
			'default'           => '#111',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_footer_nav_text_color', array(
			'label'     => __( 'フッターメニューの文字色', 'lab23' ),
			'section'   => 'colors',
			'settings'  => 'lab23_footer_nav_text_color',
			'priority'  => 10,
		) ) );
		$wp_customize->add_setting( 'lab23_copyright_bg_color', array(
			'type'              => 'option',
			'default'           => '#111',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_copyright_bg_color', array(
			'label'     => __( 'コピーライトの背景色','lab23' ),
			'section'   => 'colors',
			'settings'  => 'lab23_copyright_bg_color',
			'priority'  => 10,
		) ) );
		$wp_customize->add_setting( 'lab23_copyright_text_color', array(
			'type'              => 'option',
			'default'           => '#fff',
			'sanitize_callback' => 'sanitize_hex_color',
		) );
		$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'lab23_copyright_text_color', array(
			'label'     => __( 'コピーライトの文字色', 'lab23' ),
			'section'   => 'colors',
			'settings'  => 'lab23_copyright_text_color',
			'priority'  => 10,
		) ) );
	}
	add_action('customize_register', 'lab23_customizer_register_color');
}
