<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Theme Directory URI.
 */
define( 'LAB23_TEMPLATE_URI', get_template_directory_uri() );
define( 'LAB23_TEMPLATE_DIR', get_template_directory() );

function lab23_theme_version() {
	$theme = wp_get_theme( get_template() );
	return $theme->Version;
}
define( 'LAB23_THEME_VERSION', lab23_theme_version() );

define( 'LAB23_HOME_URL', esc_url( home_url() ) );

define( 'LAB23_TEXT_DOMAIN', 'lab23' );

define( 'LAB23_BLOG_NAME', get_bloginfo( 'name' ) );

define( 'LAB23_BLOG_DESCRIPTION', get_bloginfo( 'description' ) );

/**
 * Check If the Device is Mobile or PC.
 */
function lab23_get_is_mobile() {
	$useragents = array(
		'iPhone',          // iPhone
		'iPod',            // iPod touch
		'^(?=.*Android)(?=.*Mobile)', // 1.5+ Android
		'dream',           // Pre 1.5 Android
		'CUPCAKE',         // 1.5+ Android
		'blackberry9500',  // Storm
		'blackberry9530',  // Storm
		'blackberry9520',  // Storm v2
		'blackberry9550',  // Storm v2
		'blackberry9800',  // Torch
		'webOS',           // Palm Pre Experimental
		'incognito',       // Other iPhone browser
		'webmate'          // Other iPhone browser
	);
	$pattern = '/'.implode('|', $useragents).'/i';
	return preg_match( $pattern, $_SERVER['HTTP_USER_AGENT'] );
}
define( 'LAB23_IS_MOBILE', lab23_get_is_mobile() );
