<?php
if ( !defined( 'ABSPATH' ) ) {
  exit;
}

$is_top_page = ( is_home() ) && $paged < 2 ;
$id_list = get_option( 'lab23_slider_id_list' );

if( !$is_top_page || empty( $id_list ) ) return;

$id_list = lab23_comma_separated_to_array( $id_list );

if ( empty( $id_list ) ) return;

$date_type	= ! empty( get_option( 'lab23_pickup_entry_date' ) ) ? get_option( 'lab23_pickup_entry_date' ) : 'post';

function lab23_get_slider_post_date( $format, $id, $type ) {
  
	if ( $type === 'post' ) {

		return get_the_date( $format, $id );

	} else if ( $type === 'update' ) {

		return get_the_modified_date( $format, $id );

	} else {
		return '';
	}
}
?>
<div class="p-home-slider">
	<div class="p-home-slider__inner swiper" id="js-home-slider">
		<ul class="p-home-slider__list swiper-wrapper">
			<?php foreach( $id_list as $post_id ): ?>
				<?php
					$post_data = get_post( $post_id );
					if ( empty( $post_data) ) continue;

					$title		= get_the_title( $post_id );
					$thumb_data = lab23_get_thumbnail_info( $post_id, 'medium_large' );

					$datetime		= lab23_get_slider_post_date( 'Y-m-d', $post_id, $date_type );
					$datetime_text	= lab23_get_slider_post_date( 'Y.m.d', $post_id, $date_type );
				?>
				<li class="p-home-slider__item swiper-slide p-card-animation">
					<a href="<?php echo get_permalink( $post_id ); ?>" class="p-home-slider__link">
						<div class="p-home-slider__thumb">
							<img src="<?php echo $thumb_data[0]; ?>" width="<?php echo $thumb_data[1]; ?>" height="<?php echo $thumb_data[2]; ?>" alt="<?php echo esc_attr( $title ); ?>" decoding="async" />
						</div>
						<div class="p-home-slider__info">
							<p class="p-home-slider__title"><?php echo lab23_mb_substr_text( $title, 40 ); ?></p>
							<p class="p-home-slider__date">
								<?php if ( $date_type === 'update' ) : ?>
									<svg xmlns="http://www.w3.org/2000/svg" width="50.918" height="54.02" viewBox="0 0 50.918 54.02"><path d="M524.716,154.038a2.053,2.053,0,0,0-3.44-1.514l-3.883,3.554a27,27,0,1,0,3.5,39.371,5,5,0,0,0-7.433-6.69A17.034,17.034,0,1,1,509.837,163l-3.628,3.322a2.054,2.054,0,0,0,1.2,3.56l15.069,1.363a2.053,2.053,0,0,0,2.238-2.046Z" transform="translate(-473.8 -150.374)"/></svg>
								<?php else : ?>
									<svg xmlns="http://www.w3.org/2000/svg" width="55.393" height="55.393" viewBox="0 0 55.393 55.393"><g transform="translate(-447.367 -210.991)"><path d="M392.414,186.7a2.492,2.492,0,0,1-1.768-.732l-8.512-8.512a2.5,2.5,0,0,1-.732-1.768V161.28a2.5,2.5,0,1,1,5,0v13.372l7.78,7.779a2.5,2.5,0,0,1-1.768,4.268" transform="translate(91.161 63)"/><path d="M383.9,203.384a27.7,27.7,0,1,1,27.7-27.7,27.727,27.727,0,0,1-27.7,27.7m0-50.393a22.7,22.7,0,1,0,22.7,22.7,22.722,22.722,0,0,0-22.7-22.7" transform="translate(91.161 63)"/></g></svg>
								<?php endif; ?>
								<time datetime="<?php echo $datetime; ?>">
									<?php echo $datetime_text; ?>
								</time>
							</p>
						</div>
					</a>
				</li>
			<?php endforeach; ?>
		</ul>
		<div class="p-home-slider__pagination swiper-pagination"></div>
		<div class="p-home-slider__prev swiper-button-prev"></div>
		<div class="p-home-slider__next swiper-button-next"></div>
	</div>
</div>