<?php

if ( is_page() ) {
	if ( get_post_meta( get_the_ID(), 'lab23_hide_information', true ) ) return;
}

$text = strip_tags( get_option( 'lab23_header_info_text', '' ) );

if ( empty( $text ) ) return;

$url = esc_url( get_option( 'lab23_header_info_url', '' ) );

$bg_color =  get_option( 'lab23_header_info_bg_color', '#333' );
$text_color =  get_option( 'lab23_header_info_text_color', '#fff' );

?>
<div class="p-header-info">
	<div class="p-header-info__inner" style="background-color:<?php echo $bg_color ?>;">
		<a href="<?php echo $url; ?>" class="p-header-info__link" style="color:<?php echo $text_color ?>;">
		<svg xmlns="http://www.w3.org/2000/svg" width="55.393" height="55.393" viewBox="0 0 55.393 55.393"><path d="M40.7,147.99a27.7,27.7,0,1,0,27.7,27.7,27.7,27.7,0,0,0-27.7-27.7m8.6,29.467-9.656,9.656a2.5,2.5,0,0,1-3.535-3.535L44,175.689,36.1,167.795a2.5,2.5,0,0,1,3.535-3.535l9.662,9.662a2.5,2.5,0,0,1,0,3.535" transform="translate(-13.005 -147.99)"/></svg>
			<span class="p-header-info__txt">
				<?php echo $text; ?>
			</span>
		</a>
	</div>
</div>