<?php

$url = get_option('lab23_header_btn_url', false);
$text = get_option('lab23_header_btn_text', '');

if (empty($url) || empty($text)) return;

$icon_type = get_option('lab23_header_btn_icon', 'none');
$hide_sp = get_option('lab23_hide_header_btn_sp', false);
$btn_color = get_option('lab23_header_btn_color', '#d31111');
$btn_text_color = get_option('lab23_header_btn_text_color', '#fff');
$border_radius = get_option('lab23_header_btn_border_radius', '6');

?>
<div class="c-header-btn <?php if($hide_sp) echo 'c-header-btn--hide-sp'; ?>">
	<a href="<?php echo esc_url($url); ?>" class="c-header-btn__link" style="background-color: <?php echo $btn_color; ?>;color: <?php echo $btn_text_color; ?>;border-radius: <?php echo $border_radius; ?>px;">
		<?php switch ($icon_type) {
			case 'mail':
		?>
				<svg xmlns="http://www.w3.org/2000/svg" width="59.263" height="44.925" viewBox="0 0 59.263 44.925">
					<g transform="translate(-211.53 -106.925)">
						<path d="M146.317,67.71a6.059,6.059,0,0,0,7.367,0L179.62,47.8a4,4,0,0,0-3.99-3.876H124.371a4,4,0,0,0-3.989,3.876Z" transform="translate(91.161 63)" />
						<path d="M161.55,66.893,179.633,80.75V53.012Z" transform="translate(91.161 63)" />
						<path d="M138.452,66.893,120.369,53.012V80.75Z" transform="translate(91.161 63)" />
						<path d="M158.149,69.5,156.206,71a10.2,10.2,0,0,1-12.41,0L141.853,69.5,120.514,85.857a3.992,3.992,0,0,0,3.857,2.993h51.26a3.994,3.994,0,0,0,3.858-2.993Z" transform="translate(91.161 63)" />
					</g>
				</svg>
			<?php
				break;

			case 'mail-solid':
			?>
				<svg xmlns="http://www.w3.org/2000/svg" width="61.244" height="47.393" viewBox="0 0 61.244 47.393">
					<path d="M65.458,42.691H15.946a5.873,5.873,0,0,0-5.866,5.866V84.219a5.872,5.872,0,0,0,5.866,5.865H65.458a5.872,5.872,0,0,0,5.866-5.865V48.557a5.873,5.873,0,0,0-5.866-5.866m-49.512,4H65.458a1.868,1.868,0,0,1,1.866,1.866v1.4L44.26,67.666a5.853,5.853,0,0,1-7.116,0L14.08,49.961v-1.4a1.868,1.868,0,0,1,1.866-1.866M67.324,55V78.728L51.857,66.876ZM29.547,66.876,14.08,78.728V55ZM65.458,86.084H15.946a1.868,1.868,0,0,1-1.866-1.865v-.452L32.832,69.4l1.876,1.44a9.857,9.857,0,0,0,11.988,0l1.876-1.44L67.324,83.767v.452a1.868,1.868,0,0,1-1.866,1.865" transform="translate(-10.08 -42.691)" />
				</svg>
			<?php
				break;

			case 'tel':
			?>
				<svg xmlns="http://www.w3.org/2000/svg" width="54.819" height="54.82" viewBox="0 0 54.819 54.82">
					<path d="M767.613,81.792c-.35-5.872-13.754-11.126-17.336-8.288-3.285,2.6-2.348,4.922-3.259,5.226s-3.83,2.553-12.77-6.376c-8.925-8.937-6.676-11.856-6.373-12.766s2.625.025,5.227-3.259c2.838-3.583-2.417-16.987-8.289-17.337-1.8-.107-5.636.228-9.733,5.2-3.192,3.875-5.243,22.664,9.764,37.509l.058.057c14.844,15.008,33.633,12.956,37.509,9.765,4.975-4.1,5.309-7.936,5.2-9.734" transform="translate(-712.809 -38.977)" />
				</svg>
			<?php
				break;

			case 'tel-solid':
			?>
				<svg xmlns="http://www.w3.org/2000/svg" width="57.826" height="57.829" viewBox="0 0 57.826 57.829">
					<path d="M631.734,95.324c-8.165,0-19.014-3.016-28.271-12.374-15.339-15.174-13.683-34.574-9.61-39.52,4.282-5.2,8.595-6.085,11.451-5.916,3.473.207,6.919,3.4,9.218,8.54,1.787,3.993,2.876,9.295.574,12.2a9.072,9.072,0,0,1-4.908,3.36c-.148,2.473,3.942,6.87,5.821,8.752s6.28,5.987,8.752,5.821a9.081,9.081,0,0,1,3.361-4.908c2.906-2.3,8.207-1.213,12.2.574,5.139,2.3,8.332,5.745,8.539,9.218.171,2.861-.716,7.17-5.915,11.451-1.922,1.582-6.026,2.8-11.213,2.8M604.666,42.495c-2.334,0-4.731,1.416-6.953,4.113-2.121,2.576-4.3,19.364,9.23,32.75l.075.075c13.386,13.534,30.174,11.352,32.751,9.23,2.83-2.33,4.248-4.852,4.1-7.293-.071-1.2-1.921-3.244-5.317-4.827-3.684-1.718-6.73-1.787-7.328-1.342a4.1,4.1,0,0,0-1.731,2.664,3.448,3.448,0,0,1-2.168,2.779c-2.675,1.134-6.734,1.368-14.853-6.742S604.6,61.724,605.71,59.1a3.485,3.485,0,0,1,2.8-2.215,4.105,4.105,0,0,0,2.665-1.731c.444-.6.375-3.642-1.344-7.328-1.583-3.4-3.626-5.245-4.826-5.317-.113-.007-.227-.01-.341-.01" transform="translate(-591.055 -37.495)" />
				</svg>
		<?php
				break;

			default:
				# code...
				break;
		} ?>
		<?php echo $text; ?>
	</a>
</div>