<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$url    = esc_url(get_the_permalink());
$title  = get_the_title();
$title  = urlencode( $title );

if (is_page()) {
    $display_share_btn = get_option( 'lab23_display_share_btn_page', false );

    if ( ! $display_share_btn ) return;
}

$style = get_option( 'lab23_share_btn_style', 'wide' );

?>
<div class="c-share-buttons c-share-buttons--<?php echo $style; ?>">
    <?php if (get_option('lab23_share_facebook', true)) : ?>
        <a href="http://www.facebook.com/share.php?u=<?php echo $url; ?>&t=<?php echo $title; ?>" class="c-share-buttons__item c-share-buttons__item--fb">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                <path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z" />
            </svg>
        </a>
    <?php endif; ?>
    <?php if (get_option('lab23_share_twitter', true)) : ?>
        <a href="http://twitter.com/share?url=<?php echo $url; ?>&text=<?php echo $title; ?>" class="c-share-buttons__item c-share-buttons__item--tw">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z" />
            </svg>
        </a>
    <?php endif; ?>
    <?php if (get_option('lab23_share_pocket', true)) : ?>
        <a href="//getpocket.com/edit?url=<?php echo $url; ?>&title=<?php echo $title; ?>" class="c-share-buttons__item c-share-buttons__item--pocket">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                <path d="M407.6 64h-367C18.5 64 0 82.5 0 104.6v135.2C0 364.5 99.7 464 224.2 464c124 0 223.8-99.5 223.8-224.2V104.6c0-22.4-17.7-40.6-40.4-40.6zm-162 268.5c-12.4 11.8-31.4 11.1-42.4 0C89.5 223.6 88.3 227.4 88.3 209.3c0-16.9 13.8-30.7 30.7-30.7 17 0 16.1 3.8 105.2 89.3 90.6-86.9 88.6-89.3 105.5-89.3 16.9 0 30.7 13.8 30.7 30.7 0 17.8-2.9 15.7-114.8 123.2z" />
            </svg>
        </a>
    <?php endif; ?>
    <?php if (get_option('lab23_share_line', true)) : ?>
        <a href="https://timeline.line.me/social-plugin/share?url=<?php echo $url; ?>" class="c-share-buttons__item c-share-buttons__item--line">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                <path d="M311 196.8v81.3c0 2.1-1.6 3.7-3.7 3.7h-13c-1.3 0-2.4-.7-3-1.5l-37.3-50.3v48.2c0 2.1-1.6 3.7-3.7 3.7h-13c-2.1 0-3.7-1.6-3.7-3.7V196.9c0-2.1 1.6-3.7 3.7-3.7h12.9c1.1 0 2.4 .6 3 1.6l37.3 50.3V196.9c0-2.1 1.6-3.7 3.7-3.7h13c2.1-.1 3.8 1.6 3.8 3.5zm-93.7-3.7h-13c-2.1 0-3.7 1.6-3.7 3.7v81.3c0 2.1 1.6 3.7 3.7 3.7h13c2.1 0 3.7-1.6 3.7-3.7V196.8c0-1.9-1.6-3.7-3.7-3.7zm-31.4 68.1H150.3V196.8c0-2.1-1.6-3.7-3.7-3.7h-13c-2.1 0-3.7 1.6-3.7 3.7v81.3c0 1 .3 1.8 1 2.5c.7 .6 1.5 1 2.5 1h52.2c2.1 0 3.7-1.6 3.7-3.7v-13c0-1.9-1.6-3.7-3.5-3.7zm193.7-68.1H327.3c-1.9 0-3.7 1.6-3.7 3.7v81.3c0 1.9 1.6 3.7 3.7 3.7h52.2c2.1 0 3.7-1.6 3.7-3.7V265c0-2.1-1.6-3.7-3.7-3.7H344V247.7h35.5c2.1 0 3.7-1.6 3.7-3.7V230.9c0-2.1-1.6-3.7-3.7-3.7H344V213.5h35.5c2.1 0 3.7-1.6 3.7-3.7v-13c-.1-1.9-1.7-3.7-3.7-3.7zM512 93.4V419.4c-.1 51.2-42.1 92.7-93.4 92.6H92.6C41.4 511.9-.1 469.8 0 418.6V92.6C.1 41.4 42.2-.1 93.4 0H419.4c51.2 .1 92.7 42.1 92.6 93.4zM441.6 233.5c0-83.4-83.7-151.3-186.4-151.3s-186.4 67.9-186.4 151.3c0 74.7 66.3 137.4 155.9 149.3c21.8 4.7 19.3 12.7 14.4 42.1c-.8 4.7-3.8 18.4 16.1 10.1s107.3-63.2 146.5-108.2c27-29.7 39.9-59.8 39.9-93.1z" />
            </svg>
        </a>
    <?php endif; ?>
    <?php if (get_option('lab23_share_pinterest', true)) : ?>
        <a href="//jp.pinterest.com/pin/create/button/?url=<?php echo $url; ?>" class="c-share-buttons__item c-share-buttons__item--pinterest">
            <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 496 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                <path d="M496 256c0 137-111 248-248 248-25.6 0-50.2-3.9-73.4-11.1 10.1-16.5 25.2-43.5 30.8-65 3-11.6 15.4-59 15.4-59 8.1 15.4 31.7 28.5 56.8 28.5 74.8 0 128.7-68.8 128.7-154.3 0-81.9-66.9-143.2-152.9-143.2-107 0-163.9 71.8-163.9 150.1 0 36.4 19.4 81.7 50.3 96.1 4.7 2.2 7.2 1.2 8.3-3.3.8-3.4 5-20.3 6.9-28.1.6-2.5.3-4.7-1.7-7.1-10.1-12.5-18.3-35.3-18.3-56.6 0-54.7 41.4-107.6 112-107.6 60.9 0 103.6 41.5 103.6 100.9 0 67.1-33.9 113.6-78 113.6-24.3 0-42.6-20.1-36.7-44.8 7-29.5 20.5-61.3 20.5-82.6 0-19-10.2-34.9-31.4-34.9-24.9 0-44.9 25.7-44.9 60.2 0 22 7.4 36.8 7.4 36.8s-24.5 103.8-29 123.2c-5 21.4-3 51.6-.9 71.2C65.4 450.9 0 361.1 0 256 0 119 111 8 248 8s248 111 248 248z" />
            </svg>
        </a>
    <?php endif; ?>
    <?php if (get_option('lab23_share_hatebu', true)) : ?>
        <a href="https://b.hatena.ne.jp/entry/<?php echo $url; ?>" class="c-share-buttons__item c-share-buttons__item--hatebu">
            <svg xmlns="http://www.w3.org/2000/svg" width="17" height="14" viewBox="0 0 17 14">
                <g transform="translate(-37 -25)">
                    <path d="M13.834-4.828a3.926,3.926,0,0,1-.409,1.815A3.739,3.739,0,0,1,12.3-1.688,5.251,5.251,0,0,1,10.482-.8a10.024,10.024,0,0,1-2.515.263H1.855v-14H7.29a19.333,19.333,0,0,1,2.478.113,5.087,5.087,0,0,1,1.556.5,2.755,2.755,0,0,1,1.189,1.086,3.076,3.076,0,0,1,.39,1.556A3.074,3.074,0,0,1,12.367-9.5a3.513,3.513,0,0,1-1.514,1.208v.075A3.945,3.945,0,0,1,13.03-7.085,3.162,3.162,0,0,1,13.834-4.828ZM9.208-10.583a1.544,1.544,0,0,0-.174-.7,1.082,1.082,0,0,0-.616-.517,2.984,2.984,0,0,0-.983-.165q-.588-.014-1.65-.014H5.447v2.962h.564q.856,0,1.457-.028a2.614,2.614,0,0,0,.95-.188,1.162,1.162,0,0,0,.639-.559A1.963,1.963,0,0,0,9.208-10.583Zm.884,5.7a1.753,1.753,0,0,0-.259-1.03,1.568,1.568,0,0,0-.879-.541,4.592,4.592,0,0,0-1.166-.132Q7.046-6.6,6.237-6.6h-.79v3.488H5.71q1.523,0,2.181-.009A3.2,3.2,0,0,0,9.1-3.362a1.483,1.483,0,0,0,.776-.625A1.854,1.854,0,0,0,10.092-4.885Z" transform="translate(35.145 39.541)" />
                    <rect width="3" height="10" transform="translate(51 25)" />
                    <circle cx="1.5" cy="1.5" r="1.5" transform="translate(51 36)" />
                </g>
            </svg>
        </a>
    <?php endif; ?>
</div>