<?php

$post_type = get_post_type();

$column = isset($args) && isset($args['column']) ? $args['column'] : '2columns';
$class = '';

if (is_single()) {
	$class = 'l-entry-content p-entry-content p-entry-content--post';
} else {
	$class = 'l-entry-content p-entry-content';
}

$class = lab23_get_heading_type_classname($class);

$disable_entry_header = false;

if ( is_page() ) {
	$post_id = get_the_ID();
	$disable_entry_header = get_post_meta( $post_id, 'lab23_disable_entry_header', true );
}

?>
<?php get_header( null, array( 'column' => $column ) ); ?>
<div class="l-content-wrap l-content-wrap--<?php echo $column; ?>">
	<div class="l-content-wrap__inner">
		<div class="l-content">
			<main class="l-content-main">
				<div class="l-content-main__inner l-content-main__inner--entry">
					<?php if ( have_posts() ) : ?>
						<?php while ( have_posts() ) : the_post(); ?>
							<?php
							if ( $post_type === 'post' ) {
								get_template_part( 'includes/content/breadcrumbs' );
							}

							if ( $post_type === 'page' ) {
								get_template_part( 'includes/content/breadcrumbs-page' );
							}
							?>
							<article class="l-article">
								<?php if ( ! $disable_entry_header ) : ?>
									<?php get_template_part( 'includes/content/entry-header' ); ?>
								<?php endif; ?>
								<div <?php post_class( $class ); ?>>
									<?php the_content(); ?>
									<?php if ( is_single() ) : ?>
										<?php if ( ! empty(get_the_tags() ) ) : ?>
											<?php $tag_icon = '<svg xmlns="http://www.w3.org/2000/svg" width="58.019" height="58.019" viewBox="0 0 58.019 58.019"><path d="M173.938,5.145A4.245,4.245,0,0,0,169.7.9L146.978.879a4.245,4.245,0,0,0-3.006,1.243L117.188,28.905a4.245,4.245,0,0,0,0,6l22.748,22.748a4.245,4.245,0,0,0,6,0l26.783-26.783a4.244,4.244,0,0,0,1.243-3.006Zm-11.8,15.669a5.735,5.735,0,1,1,0-8.11,5.734,5.734,0,0,1,0,8.11" transform="translate(-115.945 -0.879)"/></svg>'; ?>
											<div class="p-article-tags">
												<?php the_tags('<ul class="p-article-tags__list"><li class="p-article-tags__item">' . $tag_icon, '</li><li class="p-article-tags__item">' . $tag_icon, '</li></ul>'); ?>
											</div>
										<?php endif; ?>
									<?php endif; ?>
								</div>
								<?php get_template_part('includes/content/entry-footer'); ?>
							</article>
						<?php endwhile; ?>
					<?php endif; ?>
					<?php if ( is_404() ) : ?>
						<header class="p-entry-header">
							<div class="p-entry-header__inner">
								<h1 class="p-entry-ttl">
									404 not found.
								</h1>
							</div>
						</header>
						<div <?php post_class( $class ); ?>>
							<p class="p-notfound-msg">
								お探しのページは削除されたか、URLが変更になったため見つかりませんでした。
							</p>
						</div>
					<?php endif; ?>
				</div>
			</main>
			<?php if ( $column === '2columns' ) : ?>
				<?php get_sidebar(); ?>
			<?php endif; ?>
		</div>
	</div>
</div>
<?php if ( is_single() ) : ?>
	<?php get_template_part( 'includes/content/json-ld' ); ?>
<?php endif; ?>
<?php get_footer(); ?>