<?php 
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! is_single() ) return;

$publisher_name  = esc_attr( get_option( 'lab23_publisher_name' ) );
$publisher_image = esc_url( get_option( 'lab23_publisher_image' ) );

if( empty( $publisher_name ) || empty( $publisher_image ) ) return;

$image_data = lab23_get_thumbnail_info( get_the_ID() );

?>
<script type="application/ld+json">
{
	"@context": "http://schema.org",
	"@type": "Article",
	"name": "<?php echo LAB23_BLOG_NAME; ?>",
	"mainEntityOfPage":"<?php the_permalink(); ?>",
	"headline": "<?php the_title(); ?>",
	"image": {
		"@type": "ImageObject",
		"url": "<?php echo $image_data[0]; ?>",
		"width":<?php echo $image_data[1]; ?>,
		"height":<?php echo $image_data[2]; ?>
	},
	"datePublished": "<?php echo get_the_date( 'c' ); ?>",
	"dateModified": "<?php echo get_the_date() !== get_the_modified_time() ? the_modified_date( 'c' ) : get_the_date( 'c' ); ?>",
	"author": {
		"@type": "Person",
		"name": "<?php the_author_meta( 'display_name' ); ?>"
	},
	"publisher": {
		"@type": "Organization",
		"name": "<?php echo $publisher_name; ?>",
		"logo": {
		"@type": "ImageObject",
			"url": "<?php echo $publisher_image; ?>"
		}
	}
}
</script>