<?php

$post_type = get_post_type();

?>
<header class="p-entry-header">
	<div class="p-entry-header__inner">
		<h1 class="p-entry-ttl">
			<?php the_title(); ?>
		</h1>
		<?php get_template_part( 'includes/content/advertisement-tag' ); ?>
		<?php if ( get_post_type() === 'post' ) : ?>
			<div class="p-entry-cat">
				<?php the_category(); ?>
			</div>
			<div class="p-entry-date">
				<?php if (get_the_time('Y-m-d') === get_the_modified_date('Y-m-d')) : ?>
					<span class="p-entry-date__post">
						<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 55.393 55.393">
							<g transform="translate(-447.367 -210.991)">
								<path d="M392.414,186.7a2.492,2.492,0,0,1-1.768-.732l-8.512-8.512a2.5,2.5,0,0,1-.732-1.768V161.28a2.5,2.5,0,1,1,5,0v13.372l7.78,7.779a2.5,2.5,0,0,1-1.768,4.268" transform="translate(91.161 63)" />
								<path d="M383.9,203.384a27.7,27.7,0,1,1,27.7-27.7,27.727,27.727,0,0,1-27.7,27.7m0-50.393a22.7,22.7,0,1,0,22.7,22.7,22.722,22.722,0,0,0-22.7-22.7" transform="translate(91.161 63)" />
							</g>
						</svg>
						<time datetime="<?php the_time('Y-m-d'); ?>"><?php the_time('Y.m.d'); ?></time>
					</span>
				<?php else : ?>
					<span class="p-entry-date__post">
						<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 55.393 55.393">
							<g transform="translate(-447.367 -210.991)">
								<path d="M392.414,186.7a2.492,2.492,0,0,1-1.768-.732l-8.512-8.512a2.5,2.5,0,0,1-.732-1.768V161.28a2.5,2.5,0,1,1,5,0v13.372l7.78,7.779a2.5,2.5,0,0,1-1.768,4.268" transform="translate(91.161 63)" />
								<path d="M383.9,203.384a27.7,27.7,0,1,1,27.7-27.7,27.727,27.727,0,0,1-27.7,27.7m0-50.393a22.7,22.7,0,1,0,22.7,22.7,22.722,22.722,0,0,0-22.7-22.7" transform="translate(91.161 63)" />
							</g>
						</svg>
						<?php the_time('Y.m.d'); ?>
					</span>
					<span class="p-entry-date__update">
						<svg xmlns="http://www.w3.org/2000/svg" width="50.918" height="54.02" viewBox="0 0 50.918 54.02">
							<path d="M524.716,154.038a2.053,2.053,0,0,0-3.44-1.514l-3.883,3.554a27,27,0,1,0,3.5,39.371,5,5,0,0,0-7.433-6.69A17.034,17.034,0,1,1,509.837,163l-3.628,3.322a2.054,2.054,0,0,0,1.2,3.56l15.069,1.363a2.053,2.053,0,0,0,2.238-2.046Z" transform="translate(-473.8 -150.374)" />
						</svg>
						<time datetime="<?php the_modified_date('Y-m-d'); ?>"><?php the_modified_date('Y.m.d') ?></time>
					</span>
				<?php endif; ?>
			</div>
			<?php if ( is_active_sidebar( 'entry-header' ) ) : ?>
				<div class="p-entry-header-widget">
					<?php dynamic_sidebar('entry-header'); ?>
				</div>
			<?php endif; ?>

		<?php endif; ?>
		<?php if (is_page()) : ?>

			<?php if (is_active_sidebar('page-header')) : ?>
				<div class="p-entry-header-widget">
					<?php dynamic_sidebar('page-header'); ?>
				</div>
			<?php endif; ?>

		<?php endif; ?>
		<?php if (has_post_thumbnail()) : ?>
			<div class="p-entry-eyecatch">
				<?php the_post_thumbnail(); ?>
			</div>
		<?php endif; ?>
		<?php if (get_option('lab23_share_btn_entry_top', true)) : ?>
			<?php get_template_part('includes/content/share-btn'); ?>
		<?php endif; ?>
	</div>
</header>