<?php
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

$author_id = get_the_author_meta( 'ID' );

// Description
$allowed_tags		= wp_kses_allowed_html( 'post' );
$author_description = wp_kses( get_the_author_meta( 'description', $author_id ), $allowed_tags );
$author_description = nl2br( $author_description );

// Avatar
$avatar_img_url = get_avatar_url( $author_id );

// Name
$author_name = get_the_author_meta( 'display_name', $author_id );

// Archive URL
$author_url = get_author_posts_url( $author_id );

// SNS
$autor_meta_tw	= esc_url( get_the_author_meta( 'twitter', $author_id ) );
$autor_meta_fb	= esc_url( get_the_author_meta( 'facebook', $author_id ) );
$autor_meta_ins	= esc_url( get_the_author_meta( 'instagram', $author_id ) );
$autor_meta_yt	= esc_url( get_the_author_meta( 'youtube_ch', $author_id ) );
?>

<div class="c-author-post">
	<p class="c-author-post__who-author"><?php _e( 'この記事を書いた人', 'lab23' ); ?></p>
	<div class="c-author-post__inner">
		<div class="c-author-post__left">
			<div class="c-author-post__icon">
				<img src="<?php echo $avatar_img_url; ?>" alt="<?php echo $author_name; ?>" loading="lazy" />
			</div>
			<p class="c-author-post__name"><?php echo $author_name; ?></p>
		</div>
		<div class="c-author-post__right">
			<div class="c-author-post__desc">
				<div class="c-author-post__desc-inner">
					<p class="c-author-post__text">
					<?php echo $author_description; ?>
					</p>
					<?php if( !empty( get_option( 'lab23_display_author_page_link' ) ) ) : ?>
					<p class="c-author-post__link"><a href="<?php echo $author_url; ?>">投稿者の記事一覧</a></p>
					<?php endif; ?>
				</div>
			</div>
			<?php if ( ! empty( $autor_meta_tw ) || ! empty( $autor_meta_fb ) || ! empty( $autor_meta_ins ) ): ?>
			<div class="c-author-follow">
				<ul class="c-author-follow__list">
				<?php if ( ! empty( $autor_meta_tw ) ): ?>
					<li class="c-author-follow__item c-author-follow__item--tw">
						<a href="<?php echo $autor_meta_tw; ?>" target="_blank" rel="noopener noreferrer" class="c-author-follow__link" aria-label="twitterをフォローする">
							<svg xmlns="http://www.w3.org/2000/svg" width="38.653" height="39.502" viewBox="0 0 38.653 39.502"><path d="M23,16.727,37.393,0h-3.41L21.489,14.523,11.51,0H0L15.09,21.962,0,39.5H3.41L16.6,24.165,27.143,39.5h11.51L23,16.727Zm-4.671,5.429L16.8,19.969,4.639,2.567H9.876l9.818,14.044L21.223,18.8,33.985,37.052H28.747l-10.414-14.9Z"/></svg>
						</a>
					</li>
				<?php endif ?>
				<?php if ( !empty( $autor_meta_fb ) ): ?>
					<li class="c-author-follow__item c-author-follow__item--fb">
						<a href="<?php echo $autor_meta_fb; ?>" target="_blank" rel="noopener noreferrer" class="c-author-follow__link" aria-label="Facebookをフォローする">
							<svg xmlns="http://www.w3.org/2000/svg" width="59.882" height="59.882" viewBox="0 0 59.882 59.882"><g transform="translate(-100 -100)"><path d="M159.882,129.941A29.941,29.941,0,1,0,122.708,159v-19.91h-6.174v-9.15h6.174V126c0-10.191,4.612-14.914,14.617-14.914a33.014,33.014,0,0,1,6.509.744v8.294c-.707-.074-1.934-.112-3.459-.112-4.909,0-6.806,1.86-6.806,6.695v3.236h9.78l-1.68,9.15h-8.1v20.572A29.945,29.945,0,0,0,159.882,129.941Z"/><path d="M263.188,220.555l1.68-9.15h-9.78V208.17c0-4.835,1.9-6.695,6.806-6.695,1.525,0,2.752.037,3.459.112v-8.294a33.014,33.014,0,0,0-6.509-.744c-10.005,0-14.617,4.723-14.617,14.914v3.943h-6.174v9.15h6.174v19.91a30.108,30.108,0,0,0,10.86.662V220.555Z" transform="translate(-121.52 -81.465)" fill="none"/></g></svg>
						</a>
					</li>
				<?php endif ?>
				<?php if ( !empty( $autor_meta_ins ) ): ?>
					<li class="c-author-follow__item c-author-follow__item--ins">
						<a href="<?php echo $autor_meta_ins; ?>" target="_blank" rel="noopener noreferrer" class="c-author-follow__link" aria-label="Instagramをフォローする">
							<svg xmlns="http://www.w3.org/2000/svg" width="42.863" height="42.863" viewBox="0 0 42.863 42.863"><path d="M15.055,2.653a15.632,15.632,0,0,0-5.2,1.006A10.488,10.488,0,0,0,6.065,6.138,10.5,10.5,0,0,0,3.6,9.936a15.746,15.746,0,0,0-.986,5.2c-.1,2.282-.123,3.015-.112,8.835s.037,6.549.147,8.836a15.666,15.666,0,0,0,1.006,5.2,10.954,10.954,0,0,0,6.28,6.256,15.733,15.733,0,0,0,5.2.986c2.281.1,3.015.123,8.834.112s6.551-.037,8.837-.145a15.68,15.68,0,0,0,5.2-1.006,10.953,10.953,0,0,0,6.255-6.28,15.676,15.676,0,0,0,.986-5.2c.1-2.288.123-3.018.112-8.837s-.037-6.549-.146-8.834a15.653,15.653,0,0,0-1.006-5.2,10.522,10.522,0,0,0-2.478-3.791,10.459,10.459,0,0,0-3.8-2.464,15.683,15.683,0,0,0-5.2-.986c-2.281-.1-3.015-.124-8.836-.113s-6.549.036-8.835.147m.25,38.743a11.893,11.893,0,0,1-3.98-.729,6.673,6.673,0,0,1-2.468-1.6,6.6,6.6,0,0,1-1.607-2.461A11.869,11.869,0,0,1,6.5,32.629c-.106-2.258-.129-2.937-.141-8.658s.009-6.4.108-8.658A11.861,11.861,0,0,1,7.2,11.333,6.637,6.637,0,0,1,8.8,8.865,6.616,6.616,0,0,1,11.26,7.257a11.868,11.868,0,0,1,3.977-.745c2.26-.107,2.937-.129,8.658-.141s6.4.009,8.661.108a11.853,11.853,0,0,1,3.979.729,7.1,7.1,0,0,1,4.076,4.061,11.807,11.807,0,0,1,.745,3.976c.108,2.26.132,2.938.142,8.658s-.01,6.4-.109,8.658a11.908,11.908,0,0,1-.729,3.982A7.1,7.1,0,0,1,36.6,40.618a11.871,11.871,0,0,1-3.976.745c-2.26.106-2.937.129-8.661.141s-6.4-.011-8.658-.108M32.777,12.48A2.572,2.572,0,1,0,35.343,9.9a2.572,2.572,0,0,0-2.567,2.576M12.927,23.956A11,11,0,1,0,23.909,12.93,11,11,0,0,0,12.927,23.956m3.86-.008a7.144,7.144,0,1,1,7.158,7.13,7.144,7.144,0,0,1-7.158-7.13" transform="translate(-2.499 -2.503)"/></svg>
						</a>
					</li>
				<?php endif ?>
				<?php if ( !empty( $autor_meta_yt ) ): ?>
					<li class="c-author-follow__item c-author-follow__item--yt">
						<a href="<?php echo $autor_meta_yt; ?>" target="_blank" rel="noopener noreferrer" class="c-author-follow__link" aria-label="Youtubeチャンネルに登録する">
							<svg xmlns="http://www.w3.org/2000/svg" width="53" height="38" viewBox="0 0 53 38"><g transform="translate(-7.5 -33.5)"><path d="M26,37c-.041,0-4.118,0-8.637-.138-2.655-.08-4.94-.191-6.794-.328A29.828,29.828,0,0,1,5.684,35.9a6.566,6.566,0,0,1-4.6-4.673,40.97,40.97,0,0,1-.951-7.907C0,20.681,0,18.522,0,18.5s0-2.181.136-4.816a45,45,0,0,1,.951-7.907A6.567,6.567,0,0,1,5.684,1.1,29.834,29.834,0,0,1,10.569.466C12.422.329,14.708.218,17.363.138,21.882,0,25.959,0,26,0s4.118,0,8.637.138c2.655.08,4.94.19,6.794.328a29.834,29.834,0,0,1,4.885.639,6.567,6.567,0,0,1,4.6,4.673,40.971,40.971,0,0,1,.951,7.907C52,16.319,52,18.478,52,18.5s0,2.181-.136,4.815a45,45,0,0,1-.951,7.907,6.566,6.566,0,0,1-4.6,4.673,29.828,29.828,0,0,1-4.885.639c-1.853.137-4.139.248-6.794.328C30.118,37,26.041,37,26,37ZM20.682,10.691V26.308L34.273,18.5Z" transform="translate(8 34)"/><path d="M26,37.5c-.041,0-4.126,0-8.652-.138-2.662-.08-4.955-.191-6.815-.329a30.219,30.219,0,0,1-4.98-.655A7.067,7.067,0,0,1,.6,31.349a41.424,41.424,0,0,1-.967-8.009C-.5,20.693-.5,18.522-.5,18.5s0-2.193.137-4.841A45.444,45.444,0,0,1,.6,5.65,7.068,7.068,0,0,1,5.553.622a30.228,30.228,0,0,1,4.979-.655c1.861-.138,4.154-.249,6.815-.329C21.875-.5,25.959-.5,26-.5s4.125,0,8.652.138c2.662.08,4.955.191,6.815.329a30.226,30.226,0,0,1,4.98.655A7.068,7.068,0,0,1,51.4,5.65a41.424,41.424,0,0,1,.967,8.009c.135,2.648.136,4.819.136,4.841s0,2.193-.136,4.841A45.441,45.441,0,0,1,51.4,31.35a7.067,7.067,0,0,1-4.95,5.028,30.221,30.221,0,0,1-4.979.655c-1.861.138-4.154.249-6.815.329C30.126,37.5,26.041,37.5,26,37.5Zm0-37c-.041,0-4.11,0-8.622.138-2.647.08-4.925.19-6.772.327a29.45,29.45,0,0,0-4.791.622A6.065,6.065,0,0,0,1.57,5.9,44.564,44.564,0,0,0,.635,13.71C.5,16.331.5,18.479.5,18.5s0,2.169.135,4.79a40.517,40.517,0,0,0,.935,7.8,6.064,6.064,0,0,0,4.245,4.318,29.441,29.441,0,0,0,4.791.623c1.846.137,4.124.247,6.772.327,4.512.136,8.582.138,8.622.138s4.11,0,8.622-.138c2.647-.08,4.925-.19,6.772-.327a29.443,29.443,0,0,0,4.791-.623A6.065,6.065,0,0,0,50.43,31.1a44.562,44.562,0,0,0,.935-7.805c.134-2.621.135-4.769.135-4.79s0-2.169-.135-4.79a40.517,40.517,0,0,0-.935-7.8,6.066,6.066,0,0,0-4.245-4.318A29.448,29.448,0,0,0,41.394.965C39.548.828,37.269.718,34.622.638,30.11.5,26.041.5,26,.5ZM20.182,27.172V9.827L35.276,18.5Zm1-15.617V25.444L33.269,18.5Z" transform="translate(8 34)" fill="rgba(0,0,0,0)"/></g></svg>
						</a>
					</li>
				<?php endif ?>
				
				</ul>
			</div>
			<?php endif; ?>
		</div>
	</div>
	
</div>