<?php

$background_color	= '#' . get_background_color();
$contents_bg_color	= null;
$contents_width		= '1000';
$text_color			= '';
$front_maxwidth		= null;

$contents_pt		= null;
$contents_plr		= null;
$contents_pb		= null;
$contents_pt_sp		= null;
$contents_plr_sp	= null;
$contents_pb_sp		= null;

$text_color_transparent_header = null;

$font = get_option( 'lab23_font_family', 'hiragino' );
$font_value = '';
$default_font = '"Hiragino Kaku Gothic ProN", "Hiragino Sans", Meiryo, sans-serif';

switch ($font) {
	case 'hiragino':
		$font_value = $default_font;
		break;

	case 'yu-gothic':
		$font_value = '"游ゴシック体", YuGothic, "游ゴシック Medium", "Yu Gothic Medium", "游ゴシック", "Yu Gothic", sans-serif';
		break;

	case 'yu-mincho':
		$font_value = '"游明朝体", "Yu Mincho", YuMincho, "ヒラギノ明朝 Pro", "Hiragino Mincho Pro", "MS P明朝", "MS PMincho", sans-serif';
		break;

	case 'noto-sans-jp':
		$font_value = '"Noto Sans JP", ' . $default_font;
		break;

	case 'noto-serif-jp':
		$font_value = '"Noto Serif JP", ' . $default_font;
		break;

	case 'm-plus':
		$font_value = '"M PLUS 1p", ' . $default_font;
		break;

	case 'm-plus-rounded':
		$font_value = '"M PLUS Rounded 1c", ' . $default_font;
		break;

	case 'zen-old-mincho':
		$font_value = '"Zen Old Mincho", ' . $default_font;
		break;

	case 'zen-maru-gothic':
		$font_value = '"Zen Maru Gothic", ' . $default_font;
		break;

	case 'zen-kurenaido':
		$font_value = '"Zen Kurenaido", ' . $default_font;
		break;

	case 'kaisei-opti':
		$font_value = '"Kaisei Opti", ' . $default_font;
		break;

	case 'yuji-syuku':
		$font_value = '"Yuji Syuku", ' . $default_font;
		break;

	case 'klee-one':
		$font_value = '"Klee One", ' . $default_font;
		break;

	case 'yomogi':
		$font_value = '"Yomogi", ' . $default_font;
		break;

	case 'hachi-maru-pop':
		$font_value = '"Hachi Maru Pop", ' . $default_font;
		break;

	default:
		$font_value = $default_font;
		break;
}

$text_color			= get_option( 'lab23_text_color', '#333' );
$title_fs			= get_option( 'lab23_font_size_title', '26' );
$title_fs_sp		= get_option( 'lab23_font_size_title_sp', '24' );
$archive_title_fs	= get_option( 'lab23_font_size_archive_title', '20' );
$archive_title_fs_sp= get_option( 'lab23_font_size_archive_title_sp', '18' );
$content_fs			= get_option( 'lab23_font_size_post', '16' );
$content_fs_sp		= get_option( 'lab23_font_size_post_sp', '16' );
$h2_fs				= get_option( 'lab23_font_size_h2', '22' );
$h3_fs				= get_option( 'lab23_font_size_h3', '20' );
$h4_fs				= get_option( 'lab23_font_size_h4', '18' );
$h5_fs				= get_option( 'lab23_font_size_h5', '16' );
$h6_fs				= get_option( 'lab23_font_size_h6', '15' );
$h2_fs_sp			= get_option( 'lab23_font_size_h2_sp', '22' );
$h3_fs_sp			= get_option( 'lab23_font_size_h3_sp', '20' );
$h4_fs_sp			= get_option( 'lab23_font_size_h4_sp', '18' );
$h5_fs_sp			= get_option( 'lab23_font_size_h5_sp', '16' );
$h6_fs_sp			= get_option( 'lab23_font_size_h6_sp', '15' );

// HOME
$mv_text = false;
$mv_font_size = false;
$mv_max_height = false;
if ( is_home() ) {
	$mv_text = get_option( 'lab23_header_image_text_color', '' );
	$mv_font_size_vw = get_option( 'lab23_header_image_font_size', '3' );
	$mv_font_size_min = get_option( 'lab23_header_image_font_size_min', '14' );
	$mv_font_size_max = get_option( 'lab23_header_image_font_size_max', '34' );
	$mv_font_size = "clamp({$mv_font_size_min}px, {$mv_font_size_vw}vw, {$mv_font_size_max}px)";
	// lab23_header_image_max_height
	$mv_max_height = get_option( 'lab23_header_image_max_height', false );
}

global $template;

$temp_name = basename($template);

if ( is_page() && $temp_name === 'page-front.php' ) {
	$page_id = get_the_ID();
	$background_color = get_post_meta( $page_id, 'lab23_container_bg_color', true ) ?: $background_color;
	$contents_bg_color = ! empty( get_post_meta( $page_id, 'lab23_page_bg_color', true ) )
		? get_post_meta( $page_id, 'lab23_page_bg_color', true )
		: '#fff';

	$contents_width 	= get_post_meta( $page_id, 'lab23_page_width', true ) ?: '1000';
	$contents_pt		= get_post_meta( $page_id, 'lab23_contents_pt', true );
	$contents_plr		= get_post_meta( $page_id, 'lab23_contents_plr', true );
	$contents_pb		= get_post_meta( $page_id, 'lab23_contents_pb', true );
	$contents_pt_sp		= get_post_meta( $page_id, 'lab23_contents_pt_sp', true );
	$contents_plr_sp	= get_post_meta( $page_id, 'lab23_contents_plr_sp', true );
	$contents_pb_sp		= get_post_meta( $page_id, 'lab23_contents_pb_sp', true );

	$text_color_transparent_header = get_post_meta( $page_id, 'lab23_text_color_transparent_header', true );
}
?>
<style>
	:root {
		--lab23-body-background-color: <?php echo preg_replace('/^#*/', '#', $background_color) ; ?>;
		--lab23-body-font: <?php echo $font_value; ?>;
		<?php if ( $contents_bg_color ) : ?>
		--lab23-contents-color: <?php echo $contents_bg_color; ?>;
		<?php endif; ?>
		<?php if ( $contents_width && is_numeric( $contents_width ) ) : ?>
		--lab23-contents-width: <?php echo $contents_width; ?>px;
		<?php endif; ?>
		<?php if ( $contents_pt && is_numeric( $contents_pt ) ) : ?>
		--lab23-contents-padding-top: <?php echo $contents_pt; ?>px;
		<?php endif; ?>
		<?php if ( $contents_plr && is_numeric( $contents_plr ) ) : ?>
		--lab23-contents-padding-left-right: <?php echo $contents_plr; ?>px;
		<?php endif; ?>
		<?php if ( $contents_pb && is_numeric( $contents_pb ) ) : ?>
		--lab23-contents-padding-bottom: <?php echo $contents_pb; ?>px;
		<?php endif; ?>
		<?php if ( $contents_pt_sp && is_numeric( $contents_pt_sp ) ) : ?>
		--lab23-contents-padding-top-sp: <?php echo $contents_pt_sp; ?>px;
		<?php endif; ?>
		<?php if ( $contents_plr_sp && is_numeric( $contents_plr_sp ) ) : ?>
		--lab23-contents-padding-left-right-sp: <?php echo $contents_plr_sp; ?>px;
		<?php endif; ?>
		<?php if ( $contents_pb_sp && is_numeric( $contents_pb_sp ) ) : ?>
		--lab23-contents-padding-bottom-sp: <?php echo $contents_pb_sp; ?>px;
		<?php endif; ?>
		<?php if ( $text_color_transparent_header && is_string( $text_color_transparent_header ) ) : ?>
		--lab23-text-color-transparent-header: <?php echo $text_color_transparent_header; ?>;
		<?php endif; ?>
		--lab23-main-color: <?php echo get_option( 'lab23_main_color', '#333' ); ?>;
		--lab23-text-color-on-main-color: <?php echo get_option( 'lab23_text_color_on_main_color', '#fff' ); ?>;
		--lab23-light-color: <?php echo get_option( 'lab23_light_color', '#f7f7f7' ); ?>;
		--lab23-header-bg-color: <?php echo get_option( 'lab23_header_bg_color', '#fff' ); ?>;
		--lab23-header-color: <?php echo get_option( 'lab23_header_color', '#333' ); ?>;
		--lab23-hamburger-bg-color: <?php echo get_option( 'lab23_hamburger_bg_color', '#fff' ); ?>;
		--lab23-hamburger-color: <?php echo get_option( 'lab23_hamburger_color', '#333' ); ?>;
		--lab23-submenu-bg-color: <?php echo get_option( 'lab23_submenu_bg_color', '#eee' ); ?>;
		--lab23-submenu-text-color: <?php echo get_option( 'lab23_submenu_text_color', '#333' ); ?>;
		--lab23-submenu-border-color: <?php echo get_option( 'lab23_submenu_border_color', '#ccc' ); ?>;
		--lab23-text-color: <?php echo $text_color; ?>;
		--lab23-border-color: <?php echo get_option( 'lab23_border_color', '#eee' ); ?>;
		--lab23-link-color: <?php echo get_option( 'lab23_link_color', '#247db4' ); ?>;
		--lab23-category-color: <?php echo get_option( 'lab23_category_color', '#eee' ); ?>;
		--lab23-category-text-color: <?php echo get_option( 'lab23_category_text_color', '#333' ); ?>;
		--lab23-tag-color: <?php echo get_option( 'lab23_tag_color', '#eee' ); ?>;
		--lab23-tag-text-color: <?php echo get_option( 'lab23_tag_text_color', '#333' ); ?>;
		--lab23-content-width: <?php echo $contents_width; ?>px;
		--lab23-comment-btn-color: <?php echo get_option( 'lab23_comment_btn_color', '#d31111' ); ?>;
		--lab23-page-top-btn-color: <?php echo get_option( 'lab23_page_top_button_color', '#111' ); ?>;
		--lab23-footer-widget-bg-color: <?php echo get_option( 'lab23_footer_widget_bg_color', '#eee' ); ?>;
		--lab23-footer-widget-text-color: <?php echo get_option( 'lab23_footer_widget_text_color', '#333' ); ?>;
		--lab23-footer-nav-bg-color: <?php echo get_option( 'lab23_footer_nav_bg_color', '#f5f5f5' ); ?>;
		--lab23-footer-nav-text-color: <?php echo get_option( 'lab23_footer_nav_text_color', '#111' ); ?>;
		--lab23-copyright-bg-color: <?php echo get_option( 'lab23_copyright_bg_color', '#111' ); ?>;
		--lab23-copyright-text-color: <?php echo get_option( 'lab23_copyright_text_color', '#fff' ); ?>;
		--lab23-archive-title-font-size: <?php echo $archive_title_fs; ?>px;
		--lab23-archive-title-font-size-sp: <?php echo $archive_title_fs_sp; ?>px;
		--lab23-post-title-font-size: <?php echo $title_fs; ?>px;
		--lab23-post-title-font-size-sp: <?php echo $title_fs_sp; ?>px;
		--lab23-post-h2-font-size: <?php echo $h2_fs; ?>px;
		--lab23-post-h2-font-size-sp: <?php echo $h2_fs; ?>px;
		--lab23-post-h3-font-size: <?php echo $h3_fs; ?>px;
		--lab23-post-h3-font-size-sp: <?php echo $h3_fs; ?>px;
		--lab23-post-h4-font-size: <?php echo $h4_fs; ?>px;
		--lab23-post-h4-font-size-sp: <?php echo $h4_fs; ?>px;
		--lab23-post-h5-font-size: <?php echo $h5_fs; ?>px;
		--lab23-post-h5-font-size-sp: <?php echo $h5_fs; ?>px;
		--lab23-post-h6-font-size: <?php echo $h6_fs; ?>px;
		--lab23-post-h6-font-size-sp: <?php echo $h6_fs; ?>px;
		--lab23-post-content-font-size: <?php echo $content_fs; ?>px;
		--lab23-post-content-font-size-sp: <?php echo $content_fs_sp; ?>px;
		--lab23-header-padding: <?php echo get_option( 'lab23_header_padding', '16' ); ?>px;
		--lab23-header-padding-sp: <?php echo get_option( 'lab23_header_padding_sp', '14' ); ?>px;
		--lab23-site-logo-height: <?php echo get_option( 'lab23_logo_image_height', '36' ); ?>px;
		--lab23-contents-max-width-2column: <?php echo get_option( 'lab23_contents_max_width_2column', '1180' ); ?>px;
		--lab23-contents-max-width-1column: <?php echo get_option( 'lab23_contents_max_width_1column', '900' ); ?>px;
		<?php if ( $mv_text ) : ?>
		--lab23-mv-text-color: <?php echo $mv_text; ?>;
		<?php endif; ?>
		<?php if ( $mv_font_size ) : ?>
		--lab23-mv-font-size: <?php echo $mv_font_size; ?>;
		<?php endif; ?>
		<?php if ( $mv_max_height ) : ?>
		--lab23-mv-max-height: <?php echo $mv_max_height; ?>px;
		<?php endif; ?>
		
	}
</style>