<?php

$header_class = lab23_get_header_classname();
$column = isset( $args ) && isset( $args['column'] ) ? $args['column'] : '2columns';
$body_class = lab23_get_body_classname( 'l-body-layout-' . $column );
$has_search = get_option( 'lab23_display_search_btn', false );

global $template;

$temp_name = basename($template);

$is_header_transparent = false;

if ( is_page() && $temp_name === 'page-front.php' ) {
	$post_id = get_the_ID();
	$is_header_transparent	= get_post_meta( $post_id, 'lab23_header_transparent', true );
}

$has_sub_header = true;

if ( ! has_nav_menu( 'sub-menu' ) && empty( get_option( 'lab23_header_info_text', '' ) ) ) {
	$has_sub_header = false;
}

if ( $is_header_transparent ) {
	$has_sub_header = false;
}

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="UTF-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<?php get_template_part( 'includes/add-style' ); ?>
	<?php wp_head(); ?>
	<?php get_template_part( 'includes/analytics' ); ?>
</head>

<body <?php body_class($body_class); ?>>
	<?php wp_body_open(); ?>
	<div class="p-viewport-height-trigger" id="js-viewport-height-trigger"></div>
	<div class="l-container">
		<div class="l-container__inner">
			<header class="<?php echo $header_class; ?>" id="header">
				<div class="l-header__inner">
					<?php get_template_part( 'includes/header/logo' ); ?>
					<div class="l-header__menus">
						<?php if ( has_nav_menu( 'global' ) ) get_template_part( 'includes/header/global-nav' ); ?>
						<?php if ( has_nav_menu( 'sp-global' ) ) get_template_part( 'includes/header/global-nav-sp' ); ?>
						<?php if ( $has_search ) get_template_part( 'includes/header/search-btn' ); ?>
						<?php get_template_part( 'includes/header/header-btn' ); ?>
					</div>
				</div>
			</header>
			<div class="p-search-overlay">
				<div class="p-search-overlay__inner">
					<?php get_search_form(); ?>
					<div class="p-search-overlay__close">
						<button class="p-search-overlay__close-btn js-close-search-overlay" aria-label="検索ボックスを閉じる"></button>
					</div>
				</div>
				<div class="p-search-overlay__bg js-close-search-overlay"></div>
			</div>
			<?php if ( $has_sub_header ) : ?>
				<div class="l-header-sub">
					<?php if ( has_nav_menu( 'sub-menu' ) ) get_template_part( 'includes/header/sub-menu' ); ?>
					<?php get_template_part( 'includes/header/information' ); ?>
				</div>
			<?php endif; ?>