<?php

$btn_type = get_option( 'lab23_page_top_btn_type', 'circle' );

$has_widget = false;

if ( is_active_sidebar( 'footer-1' ) || is_active_sidebar( 'footer-2' ) || is_active_sidebar( 'footer-3' ) ) {
	$has_widget = true;
}

?>
			<footer class="l-footer">
				<div class="l-footer__inner">
					<?php if ( $has_widget ) : ?>
						<div class="p-footer-widget">
							<div class="p-footer-widget__inner">
								<?php if ( is_active_sidebar( 'footer-1' ) ) : ?>
									<div class="p-footer-widget__item">
										<?php dynamic_sidebar('footer-1'); ?>
									</div>
								<?php endif; ?>
								<?php if ( is_active_sidebar( 'footer-2' ) ) : ?>
									<div class="p-footer-widget__item">
										<?php dynamic_sidebar('footer-2'); ?>
									</div>
								<?php endif; ?>
								<?php if ( is_active_sidebar( 'footer-3' ) ) : ?>
									<div class="p-footer-widget__item">
										<?php dynamic_sidebar('footer-3'); ?>
									</div>
								<?php endif; ?>
							</div>
						</div>
					<?php endif; ?>
					<?php if ( has_nav_menu( 'footer' ) ) : ?>
						<div class="p-footer-nav-wrap">
							<?php
							wp_nav_menu( array(
								'theme_location'	=> 'footer',
								'menu_class'		=> 'p-footer-nav-list',
								'container'			=> 'nav',
								'container_class' 	=> 'p-footer-nav',
								'depth'				=> 1,
							) );
							?>
						</div>
					<?php endif; ?>
					<div class="footer__bottom">
						<?php get_template_part( 'includes/footer/copyright' ); ?>
					</div>
				</div>
				<div class="c-page-top c-page-top--<?php echo $btn_type; ?>">
					<a href="#" class="c-page-top__btn" aria-label="Page Top"></a>
				</div>
			</footer>
		</div><!-- /.container__inner -->
	</div><!-- /.container -->
<?php wp_footer(); ?>
</body>
</html>