<?php

/**
 * Plugin Name: Lab23 Blocks
 * Description: Lab23用ブロックプラグイン
 * Version: 1.1.7
 * Author: TomiwaTech.Inc
 * Author URI: https://tomiwa-tech.co.jp/
 * Requires PHP: 7.4
 * Text Domain: lab23-blocks
 * License: GNU General Public License v2 or later
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'L23B_VERSION', '1.1.7' );
define( 'L23B_PLUGIN_DIR_URL', plugin_dir_url(__FILE__) );
define( 'L23B_PLUGIN_DIR', dirname(__FILE__) );
define( 'L23B_BLOCKS_HOME_URL', home_url() );
define( 'L23B_TEXT_DOMAIN', 'lab23-blocks' );

load_plugin_textdomain(
    L23B_TEXT_DOMAIN,
    false,
    basename(dirname(__FILE__)) . '/languages'
);

require( L23B_PLUGIN_DIR . '/lib/index.php' );

function l23b_blocks_categories($categories)
{
    array_splice(
        $categories,
        0, // 指定の位置
        0,
        array(
            array(
                'slug' => 'l23b-category-lp',
                'title' => __('【Lab23】LP作成用ブロック', 'lab23-blocks'),
            ),
            array(
                'slug' => 'l23b-category-front-page',
                'title' => __('【Lab23】トップページ用 - テンプレートを「トップページ用」にしてご利用ください。', 'lab23-blocks'),
            ),
            array(
                'slug' => 'l23b-category-section',
                'title' => __('【Lab23】セクション', 'lab23-blocks'),
            ),
            array(
                'slug' => 'l23b-category-cta',
                'title' => __('【Lab23】CTA', 'lab23-blocks'),
            ),
            array(
                'slug' => 'l23b-category-box',
                'title' => __('【Lab23】ボックス', 'lab23-blocks'),
            ),
            array(
                'slug' => 'l23b-category-card',
                'title' => __('【Lab23】カード', 'lab23-blocks'),
            ),
            array(
                'slug' => 'l23b-category-contents',
                'title' => __('【Lab23】コンテンツ', 'lab23-blocks'),
            ),
            array(
                'slug' => 'l23b-category-layout',
                'title' => __('【Lab23】レイアウト', 'lab23-blocks'),
            ),
        )
    );

    return $categories;
}
if (version_compare($GLOBALS['wp_version'], '5.8-alpha-1', '<')) {
    add_filter('block_categories', 'l23b_blocks_categories', 10, 2);
} else {
    add_filter('block_categories_all', 'l23b_blocks_categories', 10, 2);
}


function l23b_register_block_type($block, $options = array())
{
    register_block_type(
        'lab23-blocks/' . $block,
        array_merge(
            array(
                'editor_script'	=> 'lab23-blocks-editor-script',
                'editor_style'	=> 'lab23-blocks-editor-style',
                'script'		=> 'lab23-blocks-script',
                'style'			=> 'lab23-blocks-style',
            ),
            $options
        )
    );
}

function l23b_blocks_register()
{
    wp_register_script(
        'lab23-blocks-editor-script',
        plugins_url('dist/editor.js', __FILE__),
        array(
            'wp-blocks',
            'wp-i18n',
            'wp-element',
            'wp-block-editor',
            'wp-components',
            'wp-element',
            'lodash',
            'wp-blob',
            'wp-data',
            'wp-hooks',
            // 'wp-core-data',
            // 'wp-icons',
            'wp-compose',
            // 'wp-edit-post',
            'wp-plugins',
            'wp-primitives',
            // 'wp-url',
            // 'wp-keycodes',
            'wp-rich-text',
            'wp-server-side-render',
        ),
        L23B_VERSION
    );

    wp_register_script(
        'lab23-blocks-script',
        plugins_url('dist/script.js', __FILE__),
        array('jquery'),
        L23B_VERSION,
        true
    );

    wp_register_style(
        'lab23-blocks-editor-style',
        plugins_url('dist/editor.css', __FILE__),
        array('wp-edit-blocks'),
        L23B_VERSION
    );

    wp_register_style(
        'lab23-blocks-style',
        plugins_url('dist/style.css', __FILE__),
        array(),
        L23B_VERSION
    );

    // 管理者のデータを取得
    $args = array(
        'orderby'    => 'ID',
        'role'        => 'Administrator',
    );
    $users_data = get_users($args);

    // 管理画面のURLを取得
    $admin_url = admin_url();

    $add_value = array(
        'path'      => L23B_PLUGIN_DIR_URL,
        'homeUrl'   => home_url('/'),
        'users'     => $users_data,
        'adminUrl'  => $admin_url,
        'postId'    => get_the_ID(),
    );

    wp_localize_script('lab23-blocks-editor-script', 'l23bJsValue', $add_value);
    wp_localize_script('lab23-blocks-script', 'l23bJsValue', $add_value);

    l23b_register_block_type('affiliate-button');
    l23b_register_block_type('box');
    l23b_register_block_type('first-view-cta');
    l23b_register_block_type('first-view-cta-item');
    l23b_register_block_type('main-visual');
    l23b_register_block_type('micro-copy');
    l23b_register_block_type('multi-buttons');
    l23b_register_block_type('numbering-box');
    l23b_register_block_type('numbering-box-list');
    l23b_register_block_type('original-button');
    l23b_register_block_type('section');
    l23b_register_block_type('section-heading');
    l23b_register_block_type('step');
    l23b_register_block_type('step-list');
    l23b_register_block_type('title-box');
}
add_action('init', 'l23b_blocks_register');

/**
 * フロント側で plugin の共通スタイルを必ず読み込む
 * （WP 6.9 の「ブロックごとのオンデマンド読み込み」に関係なく出す）
 */
function lpcb_enqueue_front_styles() {
    if ( is_admin() ) {
        return;
    }
    // init フックで register_style 済みなので、そのハンドルをここで enqueue
    wp_enqueue_style( 'lab23-blocks-style' );
}
add_action( 'wp_enqueue_scripts', 'lpcb_enqueue_front_styles', 20 );

function l23b_set_js_value() {
    $post_id = get_the_ID();

    $countdown_settings = array(
        'type'          => get_post_meta( $post_id, '_l23b_countdown_type', true ) ?: 'elapsed',
        'elapsedTime'   => get_post_meta( $post_id, '_l23b_countdown_finish_elapsed_time', true ) ?: '',
        'finishDatetime'=> get_post_meta( $post_id, '_l23b_countdown_finish_datetime', true ) ?: '',
    );
    $add_value = array(
        'postId' => $post_id,
        'countdownSettings' => $countdown_settings,
    );
    wp_localize_script('lab23-blocks-script', 'l23bFrontJsValue', $add_value);
}
add_action('wp_enqueue_scripts', 'l23b_set_js_value', 1);

function l23b_admin_scripts() {
    wp_enqueue_style('wp-color-picker');
    wp_enqueue_style(
        'lab23-blocks-admin-style',
        plugins_url('dist/admin.css', __FILE__),
        array(),
        L23B_VERSION
    );
}

add_action('admin_print_scripts', 'l23b_admin_scripts');

function l23b_admin_styles() {
    
    wp_enqueue_script('wp-color-picker');
    wp_enqueue_script(
        'lab23-blocks-admin-script',
        plugins_url('dist/admin.js', __FILE__),
        array(
            'wp-color-picker',
            'jquery'
        ),
        L23B_VERSION
    );
}
add_action('admin_print_styles', 'l23b_admin_styles');

/**
 * ウィジェットにクラス名を追加
 */
function l23b_widget_add_classname($classname, $block_name) {

    switch ( $block_name ) {
        case 'lab23-blocks/related-post':
            $classname .= ' p-widget--related-post';
            break;
    }
    
    return $classname;
}
add_filter( 'widget_block_dynamic_classname', 'l23b_widget_add_classname', 10, 2 );

/**
 * Update Check
 */
require L23B_PLUGIN_DIR . '/update-checker/plugin-update-checker.php';

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

/**
 * updateチェックOK
 */
try {
    $myUpdateChecker = PucFactory::buildUpdateChecker(
        //'https://lab23.jp/update/plugin_file/plugin.json',
        'https://tomiwa-tech.co.jp/theme_file/lab23/plugin.json',
        __FILE__,
        'lab23-blocks'
    );
} catch (Exception $e) {
    
}

/**
 * 固定ボタンブロックが使われているページでのみ、余白調整用のJSを読み込む
 */
function l23b_enqueue_fixed_button_script() {
    // 管理画面または REST API 経由のリクエスト時はスクリプトを読み込まない
    if ( is_admin() || wp_is_json_request() ) return;

    wp_enqueue_script(
        'lab23-fixed-button-padding',
        plugins_url('dist/fixedbutton.js', __FILE__),
        [],
        L23B_VERSION,
        true
    );
}
add_action('wp_enqueue_scripts', 'l23b_enqueue_fixed_button_script');
